/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.lifecycle;

import com.ibm.msg.client.commonservices.workqueue.WorkQueueManager;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.mule.sdk.api.artifact.lifecycle.ArtifactLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBMMQArtifactLifecycleListener
implements ArtifactLifecycleListener {
    private static Logger LOGGER = LoggerFactory.getLogger(IBMMQArtifactLifecycleListener.class);
    private static final String JMSCC_THREAD_POOL_MAIN_NAME = "JMSCCThreadPoolMaster";

    public void onArtifactDisposal(ArtifactDisposalContext artifactDisposalContext) {
        this.disposeMQThreads(artifactDisposalContext);
    }

    private void disposeMQThreads(ArtifactDisposalContext artifactDisposalContext) {
        String shouldAvoid = System.getProperty("avoid.dispose.mq.threads");
        if (Boolean.valueOf(shouldAvoid).booleanValue()) {
            return;
        }
        List<Thread> artifactThreads = artifactDisposalContext.getArtifactOwnedThreads().filter(thread -> thread.getName().equals(JMSCC_THREAD_POOL_MAIN_NAME)).collect(Collectors.toList());
        List extensionThreads = artifactDisposalContext.getExtensionOwnedThreads().filter(thread -> thread.getName().equals(JMSCC_THREAD_POOL_MAIN_NAME)).collect(Collectors.toList());
        artifactThreads.addAll(extensionThreads);
        if (!artifactThreads.isEmpty()) {
            artifactThreads.forEach(thread -> this.closeWorkerThread((Thread)thread));
            try {
                if (artifactDisposalContext.isExtensionOwnedClassLoader(WorkQueueManager.class.getClassLoader()) || artifactDisposalContext.isArtifactOwnedClassLoader(WorkQueueManager.class.getClassLoader())) {
                    WorkQueueManager.close();
                }
            }
            catch (Throwable e) {
                LOGGER.error("An error occurred trying to close the WorkQueueManager", e);
            }
        }
    }

    private void closeWorkerThread(Thread thread) {
        if (SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_17)) {
            return;
        }
        try {
            Class<?> threadClass = thread.getClass();
            Method closeMethod = threadClass.getDeclaredMethod("close", new Class[0]);
            closeMethod.setAccessible(true);
            closeMethod.invoke((Object)thread, new Object[0]);
            LOGGER.debug("Thread name : " + thread.getName());
            thread.interrupt();
        }
        catch (Throwable e) {
            LOGGER.error("An error occurred trying to close the 'JMSCCThreadPoolMaster' Thread", e);
        }
    }
}

