/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.lock;

import java.util.HashSet;
import java.util.Set;
import org.mule.jms.commons.api.lock.JmsListenerLockFactory;
import org.mule.jms.commons.internal.config.InternalAckMode;
import org.mule.jms.commons.internal.source.JmsListenerLock;
import org.mule.runtime.api.message.Error;

public class ManagedJmsListenerLockFactory
implements JmsListenerLockFactory {
    private final JmsListenerLockFactory delegate;
    protected Set<JmsListenerLock> managedLocks = new HashSet<JmsListenerLock>();

    public ManagedJmsListenerLockFactory(JmsListenerLockFactory delegate) {
        this.delegate = delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JmsListenerLock createLock(InternalAckMode resolvedAckMode) {
        JmsListenerLock lock = this.delegate.createLock(resolvedAckMode);
        Set<JmsListenerLock> set = this.managedLocks;
        synchronized (set) {
            this.managedLocks.add(lock);
        }
        return new ManagedJmsListenerLockDecorator(lock);
    }

    public void setEnabled(boolean enabled) {
        this.delegate.setEnabled(enabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseOutstandingLocks() {
        Set<JmsListenerLock> set = this.managedLocks;
        synchronized (set) {
            this.managedLocks.forEach(JmsListenerLock::unlock);
            this.managedLocks.clear();
        }
    }

    private class ManagedJmsListenerLockDecorator
    implements JmsListenerLock {
        private final JmsListenerLock lock;

        private ManagedJmsListenerLockDecorator(JmsListenerLock delegate) {
            this.lock = delegate;
        }

        public void unlock() {
            this.lock.unlock();
        }

        public void lock() {
            this.lock.lock();
        }

        public void unlockWithFailure() {
            this.lock.unlockWithFailure();
        }

        public void unlockWithFailure(Error error) {
            this.lock.unlockWithFailure(error);
        }

        public void executeOnListenerThread(Runnable runnable) {
            this.lock.executeOnListenerThread(runnable);
        }

        public void init() {
            this.lock.init();
        }
    }
}

