/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.connection;

import com.ibm.msg.client.commonservices.workqueue.WorkQueueManager;
import com.mulesoft.connectors.ibmmq.api.MQJmsSpec;
import com.mulesoft.connectors.ibmmq.api.MQTargetClient;
import com.mulesoft.connectors.ibmmq.api.connection.cache.MQCachingStrategy;
import com.mulesoft.connectors.ibmmq.api.connection.cache.MQDefaultCachingStrategy;
import com.mulesoft.connectors.ibmmq.api.connection.mode.BindingConnectionMode;
import com.mulesoft.connectors.ibmmq.api.connection.mode.ClientConnectionMode;
import com.mulesoft.connectors.ibmmq.api.connection.mode.MQConnectionMode;
import com.mulesoft.connectors.ibmmq.api.ssl.SSLConfiguration;
import com.mulesoft.connectors.ibmmq.internal.connection.IBMMQConnectionFactorySupplier;
import com.mulesoft.connectors.ibmmq.internal.connection.IBMMQSessionManager;
import com.mulesoft.connectors.ibmmq.internal.connection.MQConnectionParameters;
import com.mulesoft.connectors.ibmmq.internal.connection.MQDestinationConfiguration;
import com.mulesoft.connectors.ibmmq.internal.connection.MQHandlers;
import com.mulesoft.connectors.ibmmq.internal.connection.SSLEnricher;
import com.mulesoft.connectors.ibmmq.internal.connection.TemporalDestinationConfiguration;
import com.mulesoft.connectors.ibmmq.internal.connection.XaPoolParameters;
import com.mulesoft.connectors.ibmmq.internal.connection.enricher.ApplicationNameEnricher;
import com.mulesoft.connectors.ibmmq.internal.connection.enricher.BindingConnectionModeEnricher;
import com.mulesoft.connectors.ibmmq.internal.connection.enricher.ClientConnectionModeEnricher;
import com.mulesoft.connectors.ibmmq.internal.connection.enricher.ConnectionFactoryEnricher;
import com.mulesoft.connectors.ibmmq.internal.connection.enricher.MQHandlersEnricher;
import com.mulesoft.connectors.ibmmq.internal.connection.enricher.TemporalDestinationConfigurationEnricher;
import com.mulesoft.connectors.ibmmq.internal.connection.support.MQJmsSupportFactory;
import com.mulesoft.connectors.ibmmq.internal.util.ExcludeFromGeneratedCoverage;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.mule.jms.commons.api.connection.JmsReconnectionManagerProvider;
import org.mule.jms.commons.api.connection.caching.CachingStrategy;
import org.mule.jms.commons.internal.connection.JmsTransactionalConnection;
import org.mule.jms.commons.internal.connection.param.GenericConnectionParameters;
import org.mule.jms.commons.internal.connection.provider.ConnectionFactoryDecoratorFactory;
import org.mule.jms.commons.internal.connection.provider.JmsConnectionProvider;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.mule.jms.commons.internal.support.JmsSupportFactory;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.component.ConfigurationProperties;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.ExternalLibraryType;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.ExternalLib;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.RefName;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Password;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.semantics.connectivity.ExcludeFromConnectivitySchema;
import org.mule.sdk.api.annotation.semantics.security.ClientId;
import org.mule.sdk.api.annotation.semantics.security.Username;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExternalLib(name="IBM MQ Client", requiredClassName="com.ibm.mq.jms.MQConnectionFactory", type=ExternalLibraryType.JAR, coordinates="com.ibm.mq:com.ibm.mq.allclient:9.3.4.1")
public class IBMMQConnectionProvider
implements CachedConnectionProvider<JmsTransactionalConnection>,
Initialisable,
Disposable {
    static final String DESTINATIONS_TAB = "Destinations";
    private static final String JMSCC_THREAD_POOL_MAIN_NAME = "JMSCCThreadPoolMaster";
    private static Logger LOGGER = LoggerFactory.getLogger(IBMMQConnectionProvider.class);
    @Inject
    private IBMMQSessionManager sessionManager;
    @Inject
    private ConfigurationProperties configurationProperties;
    @Inject
    private MuleContext muleContext;
    @Inject
    private Registry registry;
    @Inject
    private JmsReconnectionManagerProvider reconnectionManagerProvider;
    @RefName
    String configName;
    @Parameter
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private MQConnectionMode connectionMode;
    @Parameter
    @Optional
    @Summary(value="Username to use to connect to the IBM MQ Server")
    @Username
    private String username;
    @Parameter
    @Optional
    @Password
    @Summary(value="Password of the used username")
    private String password;
    @Parameter
    @Optional
    @DisplayName(value="Client ID")
    @Summary(value="ID of the JMS Client used to identify the current client.")
    @ClientId
    private String clientId;
    @Parameter
    @DisplayName(value="CCSID")
    @Summary(value="CCSID (coded character set identifier) to use when connecting to the queue manager. The default value (819) is suitable in most situations.")
    @Optional
    int cssId;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @NullSafe
    @Placement(tab="Advanced")
    @Summary(value="Additional properties to configure the IBM MQ Client.")
    private Map<String, String> additionalProperties;
    @ParameterGroup(name="Destination Configuration")
    private MQDestinationConfiguration destinationConfiguration;
    @Parameter
    @Optional
    @NullSafe(defaultImplementingType=MQDefaultCachingStrategy.class)
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The strategy to be used for caching of Sessions and Connections")
    @ExcludeFromConnectivitySchema
    private MQCachingStrategy cachingStrategy;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Enable XA Transactions")
    @Placement(tab="Advanced")
    @ExcludeFromConnectivitySchema
    private boolean enableXa;
    @ParameterGroup(name="Temporal Destinations")
    private TemporalDestinationConfiguration temporalDestinationConfiguration;
    @ParameterGroup(name="Handlers Config", showInDsl=true)
    private MQHandlers handlers;
    @ParameterGroup(name="XA Connection Pool", showInDsl=true)
    private XaPoolParameters xaPoolParameters;
    @Parameter
    @Optional(defaultValue="JMS_2_0")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Version of the JMS specification of the used JMS Client ")
    private MQJmsSpec specification;
    @Parameter
    @Optional(defaultValue="JMS_COMPLIANT")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Describes the way to create the IBM MQ JMS Client. When using JMS_COMPLIANT indicates that the RFH2 format is used to send information. The RFH2 header carries JMS-specific data that is associated with the message content. When not using JMS_COMPLIANT features like User Properties and Media Type propagation will stop working.")
    private MQTargetClient targetClient;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Application name to be registered in the connection factory. By default this will be the application name. Max 27 characters is allowed.")
    private String applicationName;
    @Parameter
    @Placement(tab="TLS/SSL")
    @DisplayName(value="SSL Configuration")
    @ParameterDsl(allowReferences=false)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ParameterGroup(name="SSL Configuration")
    private SSLConfiguration sslConfiguration;
    private JmsConnectionProvider jmsConnectionProvider;

    public JmsTransactionalConnection connect() throws ConnectionException {
        JmsTransactionalConnection conn;
        block2: {
            this.sessionManager.createdConnections.incrementAndGet();
            conn = this.jmsConnectionProvider.connect();
            try {
                this.setTCCLForQueueManagerThread();
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block2;
                LOGGER.debug("error occured while trying to set TCCL of JMSCC_THREAD_POOL_MAIN_NAME to MulePluginClassLoader[For Runtime v4.6.0+]/MuleArtifactClassLoader [For Runtime v4.4.0] ", (Throwable)e);
            }
        }
        return conn;
    }

    public void disconnect(JmsTransactionalConnection connection) {
        this.sessionManager.createdConnections.decrementAndGet();
        this.jmsConnectionProvider.disconnect(connection);
    }

    public ConnectionValidationResult validate(JmsTransactionalConnection connection) {
        return this.jmsConnectionProvider.validate(connection);
    }

    public void initialise() throws InitialisationException {
        MQConnectionParameters connectionParameters = new MQConnectionParameters(this.username, this.password, this.clientId);
        MQJmsSupportFactory jmsSupportFactory = new MQJmsSupportFactory(this.targetClient, this.destinationConfiguration);
        this.initialiseCipherMapping();
        this.jmsConnectionProvider = new JmsConnectionProvider((JmsSessionManager)this.sessionManager, (Supplier)this.getConnectionFactorySupplier(), this.specification.getJmsSpecification(), (GenericConnectionParameters)connectionParameters, (org.mule.jms.commons.internal.connection.param.XaPoolParameters)this.xaPoolParameters, (CachingStrategy)this.cachingStrategy, this.enableXa, (JmsSupportFactory)jmsSupportFactory, new ConnectionFactoryDecoratorFactory(this.muleContext, this.registry), this.configName, true, this.reconnectionManagerProvider.getReconnectionManager(this.configName));
    }

    public void dispose() {
        this.disableCipherMapping();
        this.disposeMQThreads();
    }

    private void setTCCLForQueueManagerThread() throws Exception {
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        for (Thread thread : threads) {
            if (!thread.getName().equals(JMSCC_THREAD_POOL_MAIN_NAME)) continue;
            this.setCorrectTCCLForThread(thread);
        }
    }

    private boolean isMuleArtifactOrMulePluginClassLoader(String classLoaderName) {
        return classLoaderName.equals("org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader") || classLoaderName.equals("org.mule.runtime.module.artifact.internal.classloader.MulePluginClassLoader");
    }

    private void setCorrectTCCLForThread(Thread thread) throws Exception {
        ClassLoader currentContextClassLoader = thread.getContextClassLoader();
        if (this.isMuleArtifactOrMulePluginClassLoader(currentContextClassLoader.getClass().getName())) {
            return;
        }
        Method getDelegates = currentContextClassLoader.getClass().getMethod("getDelegates", new Class[0]);
        Object classLoaderListObj = getDelegates.invoke((Object)thread.getContextClassLoader(), new Object[0]);
        List classLoaderList = (List)classLoaderListObj;
        for (Object classLoaderObj : classLoaderList) {
            ClassLoader cl = (ClassLoader)classLoaderObj;
            if (!this.isMuleArtifactOrMulePluginClassLoader(cl.getClass().getName())) continue;
            thread.setContextClassLoader(cl);
            break;
        }
    }

    private IBMMQConnectionFactorySupplier getConnectionFactorySupplier() {
        return new IBMMQConnectionFactorySupplier(this.clientId, this.additionalProperties, this.enableXa, this.cssId, new MQHandlersEnricher(this.handlers), new TemporalDestinationConfigurationEnricher(this.temporalDestinationConfiguration), this.getConnectionModeEnricher(this.connectionMode), new ApplicationNameEnricher(this.applicationName, this.configurationProperties), new SSLEnricher(this.sslConfiguration));
    }

    private ConnectionFactoryEnricher getConnectionModeEnricher(MQConnectionMode mqConnectionMode) {
        if (mqConnectionMode instanceof ClientConnectionMode) {
            return new ClientConnectionModeEnricher((ClientConnectionMode)mqConnectionMode);
        }
        if (mqConnectionMode instanceof BindingConnectionMode) {
            return new BindingConnectionModeEnricher((BindingConnectionMode)mqConnectionMode);
        }
        throw new IllegalArgumentException("Unsupported MQ Connection Mode: " + mqConnectionMode.getClass());
    }

    @ExcludeFromGeneratedCoverage
    private void disposeMQThreads() {
        MuleVersion muleVersion = new MuleVersion(MuleManifest.getProductVersion());
        String shouldAvoid = System.getProperty("avoid.dispose.mq.threads");
        if (Boolean.valueOf(shouldAvoid).booleanValue() || muleVersion.sameBaseVersion(new MuleVersion("4.5.0")) || muleVersion.atLeast("4.3.0-20231026") && muleVersion.sameBaseVersion(new MuleVersion("4.3.0")) || muleVersion.atLeast("4.4.0-20231026") && muleVersion.sameBaseVersion(new MuleVersion("4.4.0"))) {
            return;
        }
        if (this.thereAreNoActiveConnections()) {
            Thread[] threads = new Thread[Thread.activeCount()];
            try {
                Thread.enumerate(threads);
            }
            catch (Throwable t) {
                LOGGER.debug("An error occurred trying to obtains available Threads. Thread cleanup will be skip", t);
                return;
            }
            for (Thread thread : threads) {
                if (!thread.getName().equals(JMSCC_THREAD_POOL_MAIN_NAME)) continue;
                this.killThreadPoolMain(thread);
            }
            try {
                WorkQueueManager.close();
            }
            catch (Throwable e) {
                LOGGER.debug("An error occurred trying to close the WorkQueueManager", e);
            }
        }
    }

    @ExcludeFromGeneratedCoverage
    private void killThreadPoolMain(Thread thread) {
        Class<?> threadClass = thread.getClass();
        boolean shouldCleanThread = this.isThreadFromCurrentClassLoader(threadClass);
        if (shouldCleanThread) {
            try {
                Method closeMethod = threadClass.getDeclaredMethod("close", new Class[0]);
                closeMethod.setAccessible(true);
                closeMethod.invoke((Object)thread, new Object[0]);
                thread.interrupt();
            }
            catch (Throwable e) {
                LOGGER.debug("An error occurred trying to close the 'JMSCCThreadPoolMaster' Thread", e);
            }
        }
    }

    @ExcludeFromGeneratedCoverage
    private boolean thereAreNoActiveConnections() {
        return this.sessionManager.createdConnections.get() == 0;
    }

    @ExcludeFromGeneratedCoverage
    private boolean isThreadFromCurrentClassLoader(Class<? extends Thread> threadClass) {
        ClassLoader threadParentClassLoader = threadClass.getClassLoader().getParent();
        ClassLoader connectorParentClassLoader = this.getClass().getClassLoader().getParent();
        return connectorParentClassLoader == threadParentClassLoader;
    }

    private void initialiseCipherMapping() {
        if (this.sslConfiguration != null) {
            this.sessionManager.initializeIBMCipherMapping(this, this.sslConfiguration.cipherSpecMapping());
        }
    }

    private void disableCipherMapping() {
        if (this.sslConfiguration != null) {
            this.sessionManager.disposeIBMCipherMapping(this);
        }
    }
}

