/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.connection.enricher;

import com.ibm.mq.jms.MQConnectionFactory;
import com.mulesoft.connectors.ibmmq.api.connection.mode.ClientConnectionMode;
import com.mulesoft.connectors.ibmmq.internal.connection.enricher.ConnectionFactoryEnricher;
import javax.jms.JMSException;

public class ClientConnectionModeEnricher
implements ConnectionFactoryEnricher {
    private ClientConnectionMode clientConnectionMode;

    public ClientConnectionModeEnricher(ClientConnectionMode clientConnectionMode) {
        this.clientConnectionMode = clientConnectionMode;
    }

    @Override
    public void configure(MQConnectionFactory connectionFactory) throws JMSException {
        connectionFactory.setTransportType(1);
        this.configureOptionally(this.clientConnectionMode.getQueueManager(), arg_0 -> ((MQConnectionFactory)connectionFactory).setQueueManager(arg_0));
        this.configureOptionally(this.clientConnectionMode.getChannel(), arg_0 -> ((MQConnectionFactory)connectionFactory).setChannel(arg_0));
        String connectionNameList = this.clientConnectionMode.getConnectionNameList();
        if (connectionNameList != null && connectionNameList.contains(",")) {
            connectionFactory.setClientReconnectOptions(0x1000000);
            connectionFactory.setClientReconnectTimeout(20);
            connectionFactory.setConnectionNameList(connectionNameList);
        } else {
            connectionFactory.setHostName(this.clientConnectionMode.getHost());
            connectionFactory.setPort(this.clientConnectionMode.getPort());
        }
    }
}

