/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.connection;

import com.mulesoft.connectors.ibmmq.api.ssl.CipherSuiteMapping;
import com.mulesoft.connectors.ibmmq.internal.connection.IBMMQConnectionProvider;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.jms.commons.internal.connection.session.JmsSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBMMQSessionManager
extends JmsSessionManager {
    AtomicInteger createdConnections = new AtomicInteger(0);
    private static final String IBMCIPHER_MAPPINGS = "com.ibm.mq.cfg.useIBMCipherMappings";
    private boolean cipherMappingInitialized = false;
    private static Map<IBMMQConnectionProvider, CipherSuiteMapping> connections = new WeakHashMap<IBMMQConnectionProvider, CipherSuiteMapping>();
    private static final Logger LOGGER = LoggerFactory.getLogger(IBMMQSessionManager.class);

    synchronized void initializeIBMCipherMapping(IBMMQConnectionProvider initializer, CipherSuiteMapping cipherSuiteMapping) {
        String property = System.getProperty(IBMCIPHER_MAPPINGS);
        String useMapping = String.valueOf(cipherSuiteMapping.isUseIbmMapping());
        if (!this.cipherMappingInitialized && property != null) {
            LOGGER.warn(String.format("The 'com.ibm.mq.cfg.useIBMCipherMappings' property has been already configured externally with value [%s], ignoring the configuration with value [%s]", property, useMapping));
        } else if (this.cipherMappingInitialized && property != null && !useMapping.equals(property.toLowerCase())) {
            LOGGER.warn(String.format("The chosen IBM Cipher Mapping configuration [%s] is incompatible to a one already configured [%s]. Ignoring the configuration.", useMapping, property));
        } else if (!cipherSuiteMapping.equals((Object)CipherSuiteMapping.NONE)) {
            this.cipherMappingInitialized = true;
            connections.put(initializer, cipherSuiteMapping);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Configuring 'com.ibm.mq.cfg.useIBMCipherMappings' System Property with value: " + useMapping);
            }
            System.setProperty(IBMCIPHER_MAPPINGS, useMapping);
        }
    }

    synchronized void disposeIBMCipherMapping(IBMMQConnectionProvider initializer) {
        if (this.cipherMappingInitialized) {
            connections.remove(initializer);
            if (connections.isEmpty()) {
                System.clearProperty(IBMCIPHER_MAPPINGS);
                LOGGER.debug("Removed com.ibm.mq.cfg.useIBMCipherMappings system property");
            }
        }
    }

    public synchronized int getNumActiveConnections() {
        return this.createdConnections.get();
    }
}

