/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.lifecycle;

import java.beans.Introspector;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Stream;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.mule.sdk.api.artifact.lifecycle.ArtifactDisposalContext;
import org.mule.sdk.api.artifact.lifecycle.ArtifactLifecycleListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBMMQArtifactLifecycleListener
implements ArtifactLifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(IBMMQArtifactLifecycleListener.class);
    private static final String IBM_MQ_MBEAN_DOMAIN = "IBM MQ";
    private static final String JMSCC_THREAD_POOL_MAIN_NAME = "JMSCCThreadPoolMaster";
    private static final String WORK_QUEUE_MANAGER_CLASSNAME = "com.ibm.msg.client.commonservices.workqueue.WorkQueueManager";
    private static final boolean AVOID_CLEANUP = Boolean.getBoolean("avoid.ibm.mq.cleanup");
    private static final boolean AVOID_CLEANUP_MBEANS = Boolean.getBoolean("avoid.ibm.mq.cleanup.mbeans");
    private static final boolean AVOID_CLEANUP_THREADS = Boolean.getBoolean("avoid.dispose.mq.threads");

    public void onArtifactDisposal(ArtifactDisposalContext artifactDisposalContext) {
        if (AVOID_CLEANUP) {
            LOGGER.debug("Avoiding IBM MQ resources cleanup.");
            return;
        }
        LOGGER.debug("Releasing IBM MQ resources");
        if (!AVOID_CLEANUP_MBEANS) {
            LOGGER.debug("Releasing IBM MQ resources - Removal of registered mBeans is called.");
            this.removeMBeans();
        }
        if (!AVOID_CLEANUP_THREADS) {
            LOGGER.debug("Releasing IBM MQ resources - Closing WorkQueueManager and its threads.");
            this.disposeWorkQueueManagerThreads(artifactDisposalContext, artifactDisposalContext.getArtifactClassLoader());
            this.disposeWorkQueueManagerThreads(artifactDisposalContext, artifactDisposalContext.getExtensionClassLoader());
        }
        ResourceBundle.clearCache(artifactDisposalContext.getArtifactClassLoader());
        ResourceBundle.clearCache(artifactDisposalContext.getExtensionClassLoader());
    }

    private void removeMBeans() {
        LOGGER.debug("Removing registered MBeans of the IBM MQ Driver (if present)");
        MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
        if (LOGGER.isDebugEnabled()) {
            Set<ObjectInstance> allInstances = mBeanServer.queryMBeans(null, null);
            allInstances.forEach(this::logObjectInstance);
        }
        this.getIbmMqMBeans(mBeanServer).forEach(objectInstance -> this.unregisterObjectInstance(mBeanServer, (ObjectInstance)objectInstance));
        Introspector.flushCaches();
    }

    private void logObjectInstance(ObjectInstance objectInstance) {
        LOGGER.debug("MBean Found: Class Name: {} // Object Name: {}", (Object)objectInstance.getClassName(), (Object)objectInstance.getObjectName());
    }

    private void unregisterObjectInstance(MBeanServer mBeanServer, ObjectInstance objectInstance) {
        try {
            mBeanServer.unregisterMBean(objectInstance.getObjectName());
        }
        catch (InstanceNotFoundException e) {
            LOGGER.debug("No instance of CommonServices/TraceControl MBean was found.");
        }
        catch (MBeanRegistrationException e) {
            LOGGER.warn("Caught exception unregistering the IBM MQ MBean: {}", (Object)e.getMessage(), (Object)e);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Unregistered {}", (Object)objectInstance.getObjectName());
        }
    }

    private Set<ObjectInstance> getIbmMqMBeans(MBeanServer mBeanServer) {
        try {
            return mBeanServer.queryMBeans(this.getIbmMqMBeanObjectName(), null);
        }
        catch (MalformedObjectNameException e) {
            LOGGER.warn("Exception building query for IBM MQ MBeans {}", (Object)e.getMessage(), (Object)e);
            return Collections.emptySet();
        }
    }

    private ObjectName getIbmMqMBeanObjectName() throws MalformedObjectNameException {
        Hashtable<String, String> keys = new Hashtable<String, String>();
        keys.put("type", "CommonServices");
        keys.put("name", "*");
        return new ObjectName(IBM_MQ_MBEAN_DOMAIN, keys);
    }

    private void disposeWorkQueueManagerThreads(ArtifactDisposalContext artifactDisposalContext, ClassLoader classLoader) {
        this.getWorkQueueManagerCloseMethod(artifactDisposalContext, classLoader).ifPresent(cls -> this.closeWorkQueueManager(artifactDisposalContext, (Method)cls));
    }

    private void closeWorkQueueManager(ArtifactDisposalContext artifactDisposalContext, Method workQueueManagerCloseMethod) {
        try {
            workQueueManagerCloseMethod.invoke(null, new Object[0]);
            this.interruptWorkQueueManagerThreads(artifactDisposalContext);
        }
        catch (Exception e) {
            LOGGER.warn("An error occurred trying to close the WorkQueueManager", (Throwable)e);
        }
    }

    private void interruptWorkQueueManagerThreads(ArtifactDisposalContext artifactDisposalContext) {
        Stream.concat(artifactDisposalContext.getArtifactOwnedThreads(), artifactDisposalContext.getExtensionOwnedThreads()).filter(thread -> thread.getName().equals(JMSCC_THREAD_POOL_MAIN_NAME)).forEach(Thread::interrupt);
    }

    private Optional<Method> getWorkQueueManagerCloseMethod(ArtifactDisposalContext artifactDisposalContext, ClassLoader classLoader) {
        try {
            Class<?> cls = classLoader.loadClass(WORK_QUEUE_MANAGER_CLASSNAME);
            if (!this.isArtifactOrExtensionOwnedClass(artifactDisposalContext, cls)) {
                return Optional.empty();
            }
            return Optional.of(cls.getMethod("close", new Class[0]));
        }
        catch (ClassNotFoundException e) {
            return Optional.empty();
        }
        catch (NoSuchMethodException e) {
            LOGGER.warn("Could not find method close from class {} to dispose worker threads. The provided driver version may have removed it.", (Object)WORK_QUEUE_MANAGER_CLASSNAME, (Object)e);
            return Optional.empty();
        }
    }

    private boolean isArtifactOrExtensionOwnedClass(ArtifactDisposalContext artifactDisposalContext, Class<?> cls) {
        ClassLoader loaderOfClass = cls.getClassLoader();
        return artifactDisposalContext.isArtifactOwnedClassLoader(loaderOfClass) || artifactDisposalContext.isExtensionOwnedClassLoader(loaderOfClass);
    }
}

