/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.operation;

import java.util.Arrays;
import javax.jms.JMSException;
import javax.jms.Message;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.mule.jms.commons.api.RequestReplyPattern;
import org.mule.jms.commons.api.RequestReplyPatternWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IBMRequestReplySelectorWrapper
implements RequestReplyPatternWrapper {
    private static final int WMQ_CORRELATION_ID_LENGTH = 24;
    private static final Logger LOGGER = LoggerFactory.getLogger(IBMRequestReplySelectorWrapper.class);

    public String createSelector(RequestReplyPattern requestReplyPattern, Message message) throws JMSException {
        if (requestReplyPattern == RequestReplyPattern.CORRELATION_ID) {
            String correlationId = this.getCorrelationIdFromWMQHeaderField(message);
            if (StringUtils.isEmpty((CharSequence)correlationId) && message.getJMSCorrelationID() != null) {
                correlationId = this.resolveCorrelationIdFromJmsApi(message);
            }
            return "JMSCorrelationID = 'ID:" + correlationId + "'";
        }
        return requestReplyPattern.createSelector(message);
    }

    private String resolveCorrelationIdFromJmsApi(Message message) throws JMSException {
        if (message.getJMSCorrelationID().length() > 24 && LOGGER.isWarnEnabled()) {
            LOGGER.warn("Correlation ID is longer than 24 bytes. It will be truncated according to WMQ requirements. CorrelationID: ", (Object)message.getJMSCorrelationID());
        }
        String correlationId = new String(Hex.encodeHex((byte[])Arrays.copyOf(message.getJMSCorrelationIDAsBytes(), 24)));
        return correlationId;
    }

    private String getCorrelationIdFromWMQHeaderField(Message message) throws JMSException {
        byte[] correlationIdProperty = (byte[])message.getObjectProperty("JMS_IBM_MQMD_CorrelId");
        return correlationIdProperty == null ? "" : new String(Hex.encodeHex((byte[])correlationIdProperty));
    }
}

