/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.api.publisher;

import com.mulesoft.connectors.ibmmq.internal.util.ExcludeFromGeneratedCoverage;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.jms.commons.api.config.JmsProducerConfig;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class MQProducerConfig
implements JmsProducerConfig {
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="If true, the Message will be sent using the PERSISTENT JMSDeliveryMode")
    private boolean persistentDelivery;
    @Parameter
    @Optional(defaultValue="4")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The default JMSPriority value to be used when sending the message")
    private int priority;
    @Parameter
    @Optional(defaultValue="0")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Defines the default time the message will be in the broker before it expires and is discarded")
    private long timeToLive;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Time unit to be used in the timeToLive configurations")
    private TimeUnit timeToLiveUnit;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="If true, the Message will be flagged to avoid generating its MessageID")
    private boolean disableMessageId;
    @Parameter
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="If true, the Message will be flagged to avoid generating its sent Timestamp")
    private boolean disableMessageTimestamp;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    @Summary(value="Only used by JMS 2.0:  Sets the delivery delay to be applied in order to postpone the Message delivery")
    private Long deliveryDelay;
    @Parameter
    @Optional(defaultValue="MILLISECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="Only used by JMS 2.0: Time unit to be used in the deliveryDelay configurations.")
    private TimeUnit deliveryDelayUnit;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Summary(value="The message type identifier to be set in the JMSType Header when a message is sent")
    private String jmsType;

    @ExcludeFromGeneratedCoverage
    public boolean isPersistentDelivery() {
        return this.persistentDelivery;
    }

    @ExcludeFromGeneratedCoverage
    public boolean getPersistentDelivery() {
        return this.persistentDelivery;
    }

    @ExcludeFromGeneratedCoverage
    public void setPersistentDelivery(boolean persistentDelivery) {
        this.persistentDelivery = persistentDelivery;
    }

    @ExcludeFromGeneratedCoverage
    public int getPriority() {
        return this.priority;
    }

    @ExcludeFromGeneratedCoverage
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @ExcludeFromGeneratedCoverage
    public long getTimeToLive() {
        return this.timeToLive;
    }

    @ExcludeFromGeneratedCoverage
    public void setTimeToLive(long timeToLive) {
        this.timeToLive = timeToLive;
    }

    @ExcludeFromGeneratedCoverage
    public TimeUnit getTimeToLiveUnit() {
        return this.timeToLiveUnit;
    }

    @ExcludeFromGeneratedCoverage
    public void setTimeToLiveUnit(TimeUnit timeToLiveUnit) {
        this.timeToLiveUnit = timeToLiveUnit;
    }

    @ExcludeFromGeneratedCoverage
    public boolean isDisableMessageId() {
        return this.disableMessageId;
    }

    @ExcludeFromGeneratedCoverage
    public boolean getDisableMessageId() {
        return this.disableMessageId;
    }

    @ExcludeFromGeneratedCoverage
    public void setDisableMessageId(boolean disableMessageId) {
        this.disableMessageId = disableMessageId;
    }

    @ExcludeFromGeneratedCoverage
    public boolean isDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    @ExcludeFromGeneratedCoverage
    public boolean getDisableMessageTimestamp() {
        return this.disableMessageTimestamp;
    }

    @ExcludeFromGeneratedCoverage
    public void setDisableMessageTimestamp(boolean disableMessageTimestamp) {
        this.disableMessageTimestamp = disableMessageTimestamp;
    }

    @ExcludeFromGeneratedCoverage
    public Long getDeliveryDelay() {
        return this.deliveryDelay;
    }

    @ExcludeFromGeneratedCoverage
    public void setDeliveryDelay(Long deliveryDelay) {
        this.deliveryDelay = deliveryDelay;
    }

    @ExcludeFromGeneratedCoverage
    public TimeUnit getDeliveryDelayUnit() {
        return this.deliveryDelayUnit;
    }

    @ExcludeFromGeneratedCoverage
    public void setDeliveryDelayUnit(TimeUnit deliveryDelayUnit) {
        this.deliveryDelayUnit = deliveryDelayUnit;
    }

    @ExcludeFromGeneratedCoverage
    public String getJmsType() {
        return this.jmsType;
    }

    @ExcludeFromGeneratedCoverage
    public void setJmsType(String jmsType) {
        this.jmsType = jmsType;
    }

    @ExcludeFromGeneratedCoverage
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MQProducerConfig that = (MQProducerConfig)o;
        return this.persistentDelivery == that.persistentDelivery && this.priority == that.priority && this.timeToLive == that.timeToLive && this.disableMessageId == that.disableMessageId && this.disableMessageTimestamp == that.disableMessageTimestamp && this.timeToLiveUnit == that.timeToLiveUnit && Objects.equals(this.deliveryDelay, that.deliveryDelay) && this.deliveryDelayUnit == that.deliveryDelayUnit && Objects.equals(this.jmsType, that.jmsType);
    }

    @ExcludeFromGeneratedCoverage
    public int hashCode() {
        return Objects.hash(new Object[]{this.persistentDelivery, this.priority, this.timeToLive, this.timeToLiveUnit, this.disableMessageId, this.disableMessageTimestamp, this.deliveryDelay, this.deliveryDelayUnit, this.jmsType});
    }
}

