/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.internal.connection;

import com.ibm.mq.jms.MQConnectionFactory;
import com.mulesoft.connectors.ibmmq.api.ssl.SSLConfiguration;
import com.mulesoft.connectors.ibmmq.internal.connection.enricher.ConnectionFactoryEnricher;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.jms.JMSException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SSLEnricher
implements ConnectionFactoryEnricher {
    private static final String SSL_CONFIGURATION_ERROR = "An error occurred trying to Configure SSL Options on IBM MQ Connection";
    private static final Logger LOGGER = LoggerFactory.getLogger(SSLEnricher.class);
    private SSLConfiguration sslConfiguration;

    SSLEnricher(SSLConfiguration sslConfiguration) {
        this.sslConfiguration = sslConfiguration;
    }

    @Override
    public void configure(MQConnectionFactory connectionFactory) throws JMSException {
        TlsContextFactory tlsContextFactory = this.sslConfiguration.getTlsContextFactory();
        if (tlsContextFactory != null) {
            try {
                LifecycleUtils.initialiseIfNeeded((Object)tlsContextFactory);
                connectionFactory.setSSLSocketFactory((Object)tlsContextFactory.createSocketFactory());
                connectionFactory.setSSLCipherSuite(this.sslConfiguration.getCipherSuite());
                connectionFactory.setSSLFipsRequired(this.sslConfiguration.isFipsRequired());
                this.configureOptionally(this.sslConfiguration.getPeerName(), arg_0 -> ((MQConnectionFactory)connectionFactory).setSSLPeerName(arg_0));
                this.configureOptionally(this.sslConfiguration.getResetCount(), arg_0 -> ((MQConnectionFactory)connectionFactory).setSSLResetCount(arg_0));
                this.configureOptionally(this.sslConfiguration.getCertStores(), arg_0 -> ((MQConnectionFactory)connectionFactory).setSSLCertStores(arg_0));
            }
            catch (KeyManagementException | NoSuchAlgorithmException | InitialisationException e) {
                LOGGER.error(SSL_CONFIGURATION_ERROR, e);
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)SSL_CONFIGURATION_ERROR), e);
            }
        }
    }
}

