/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.ibmmq.api.ssl;

import com.mulesoft.connectors.ibmmq.api.ssl.CipherSuiteMapping;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.values.ValueBuilder;
import org.mule.runtime.extension.api.values.ValueProvider;
import org.mule.runtime.extension.api.values.ValueResolvingException;

public class CipherSuiteMappingValueProvider
implements ValueProvider {
    @Parameter
    private boolean fipsRequired;
    @Parameter
    private CipherSuiteMapping cipherSuiteMapping;
    private static final List<Cipher> oracleCiphers;
    private static final List<Cipher> ibmCiphers;
    private static final List<Cipher> tls13Ciphers;

    public Set<Value> resolve() throws ValueResolvingException {
        List<Cipher> ciphers = this.cipherSuiteMapping.equals((Object)CipherSuiteMapping.ORACLE_CIPHER_SUITES) ? oracleCiphers : (this.cipherSuiteMapping.equals((Object)CipherSuiteMapping.IBM_CIPHER_SUITES) ? ibmCiphers : Collections.emptyList());
        return ValueBuilder.getValuesFor(ciphers.stream().filter(c -> this.fipsRequired ? c.isFipsCompatible() : true).map(Cipher::getName));
    }

    static {
        tls13Ciphers = new ArrayList<Cipher>();
        tls13Ciphers.add(new Cipher("TLS_AES_128_GCM_SHA256"));
        tls13Ciphers.add(new Cipher("TLS_AES_256_GCM_SHA384"));
        tls13Ciphers.add(new Cipher("TLS_CHACHA20_POLY1305_SHA256", false));
        tls13Ciphers.add(new Cipher("*TLS13ORHIGHER", false));
        tls13Ciphers.add(new Cipher("*TLS12ORHIGHER", false));
        tls13Ciphers.add(new Cipher("*TLS13", false));
        oracleCiphers = new ArrayList<Cipher>();
        oracleCiphers.add(new Cipher("TLS_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA"));
        oracleCiphers.add(new Cipher("TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"));
        oracleCiphers.add(new Cipher("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"));
        oracleCiphers.add(new Cipher("TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384"));
        oracleCiphers.add(new Cipher("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"));
        oracleCiphers.add(new Cipher("TLS_ECDHE_ECDSA_WITH_NULL_SHA", false));
        oracleCiphers.add(new Cipher("TLS_ECDHE_ECDSA_WITH_RC4_128_SHA", false));
        oracleCiphers.add(new Cipher("TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA"));
        oracleCiphers.add(new Cipher("TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"));
        oracleCiphers.add(new Cipher("TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384"));
        oracleCiphers.add(new Cipher("TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384"));
        oracleCiphers.add(new Cipher("TLS_ECDHE_RSA_WITH_NULL_SHA", false));
        oracleCiphers.add(new Cipher("TLS_ECDHE_RSA_WITH_RC4_128_SHA", false));
        oracleCiphers.add(new Cipher("SSL_RSA_WITH_3DES_EDE_CBC_SHA", false));
        oracleCiphers.add(new Cipher("TLS_RSA_WITH_AES_128_CBC_SHA"));
        oracleCiphers.add(new Cipher("TLS_RSA_WITH_AES_128_CBC_SHA256"));
        oracleCiphers.add(new Cipher("TLS_RSA_WITH_AES_128_GCM_SHA256"));
        oracleCiphers.add(new Cipher("TLS_RSA_WITH_AES_256_CBC_SHA"));
        oracleCiphers.add(new Cipher("TLS_RSA_WITH_AES_256_CBC_SHA256"));
        oracleCiphers.add(new Cipher("TLS_RSA_WITH_AES_256_GCM_SHA384"));
        oracleCiphers.add(new Cipher("SSL_RSA_WITH_DES_CBC_SHA", false));
        oracleCiphers.add(new Cipher("SSL_RSA_WITH_NULL_MD5", false));
        oracleCiphers.add(new Cipher("SSL_RSA_WITH_NULL_SHA", false));
        oracleCiphers.add(new Cipher("TLS_RSA_WITH_NULL_SHA256", false));
        oracleCiphers.add(new Cipher("SSL_RSA_WITH_RC4_128_MD5", false));
        oracleCiphers.add(new Cipher("SSL_RSA_WITH_RC4_128_SHA", false));
        oracleCiphers.addAll(tls13Ciphers);
        ibmCiphers = new ArrayList<Cipher>();
        ibmCiphers.add(new Cipher("SSL_ECDHE_ECDSA_WITH_3DES_EDE_CBC_SHA"));
        ibmCiphers.add(new Cipher("SSL_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256"));
        ibmCiphers.add(new Cipher("SSL_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256"));
        ibmCiphers.add(new Cipher("SSL_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384"));
        ibmCiphers.add(new Cipher("SSL_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"));
        ibmCiphers.add(new Cipher("SSL_ECDHE_ECDSA_WITH_NULL_SHA", false));
        ibmCiphers.add(new Cipher("SSL_ECDHE_ECDSA_WITH_RC4_128_SHA", false));
        ibmCiphers.add(new Cipher("SSL_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA"));
        ibmCiphers.add(new Cipher("SSL_ECDHE_RSA_WITH_AES_128_CBC_SHA256"));
        ibmCiphers.add(new Cipher("SSL_ECDHE_RSA_WITH_AES_128_GCM_SHA256"));
        ibmCiphers.add(new Cipher("SSL_ECDHE_RSA_WITH_AES_256_CBC_SHA384"));
        ibmCiphers.add(new Cipher("SSL_ECDHE_RSA_WITH_AES_256_GCM_SHA384"));
        ibmCiphers.add(new Cipher("SSL_ECDHE_RSA_WITH_NULL_SHA", false));
        ibmCiphers.add(new Cipher("SSL_ECDHE_RSA_WITH_RC4_128_SHA", false));
        ibmCiphers.add(new Cipher("SSL_RSA_EXPORT_WITH_RC4_40_MD5", false));
        ibmCiphers.add(new Cipher("SSL_RSA_FIPS_WITH_3DES_EDE_CBC_SHA", false));
        ibmCiphers.add(new Cipher("SSL_RSA_FIPS_WITH_DES_CBC_SHA", false));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_3DES_EDE_CBC_SHA"));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_AES_128_CBC_SHA"));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_AES_128_CBC_SHA256"));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_AES_128_GCM_SHA256"));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_AES_256_CBC_SHA"));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_AES_256_CBC_SHA256"));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_AES_256_GCM_SHA384"));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_DES_CBC_SHA", false));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_NULL_MD5", false));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_NULL_SHA", false));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_NULL_SHA256", false));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_RC4_128_MD5", false));
        ibmCiphers.add(new Cipher("SSL_RSA_WITH_RC4_128_SHA", false));
        ibmCiphers.add(new Cipher("TLS_AES_128_CCM_SHA256"));
        ibmCiphers.add(new Cipher("TLS_AES_128_CCM_8_SHA256"));
        ibmCiphers.addAll(tls13Ciphers);
    }

    private static class Cipher {
        private String name;
        private boolean fipsCompatible;

        Cipher(String name, boolean fipsCompatible) {
            this.name = name;
            this.fipsCompatible = fipsCompatible;
        }

        Cipher(String name) {
            this(name, true);
        }

        String getName() {
            return this.name;
        }

        boolean isFipsCompatible() {
            return this.fipsCompatible;
        }
    }
}

