/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.kafka.internal.connection.provider;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.mule.modules.kafka.internal.connection.KafkaConsumerConnection;
import org.mule.modules.kafka.internal.connection.provider.AbstractKafkaConnectionProvider;
import org.mule.modules.kafka.internal.connection.provider.param.ConsumerParamsGroup;
import org.mule.modules.kafka.internal.service.MuleConsumer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;

@Alias(value="kafka-consumer-connection")
@DisplayName(value="Kafka Consumer Connection")
public abstract class KafkaConsumerConnectionProvider
extends AbstractKafkaConnectionProvider<KafkaConsumerConnection> {
    @ParameterGroup(name="Consumers")
    @Placement(order=1)
    private ConsumerParamsGroup consumerParamsGoup;

    public ConsumerParamsGroup getConsumerParamsGoup() {
        return this.consumerParamsGoup;
    }

    public void setConsumerParamsGoup(ConsumerParamsGroup consumerParamsGoup) {
        this.consumerParamsGoup = consumerParamsGoup;
    }

    @Override
    public KafkaConsumerConnection connect(Properties properties) throws ConnectionException {
        properties.setProperty("group.id", this.consumerParamsGoup.getGroupId());
        return new KafkaConsumerConnection(new MuleConsumer(this.getConsumers(properties), Executors.newFixedThreadPool(this.consumerParamsGoup.getConsumerPartitions()), this.consumerParamsGoup.getConsumerPartitions()));
    }

    public void disconnect(KafkaConsumerConnection kafkaConsumerConnection) {
        if (kafkaConsumerConnection.getMuleConsumer() != null) {
            kafkaConsumerConnection.getMuleConsumer().shutdown();
        }
    }

    public ConnectionValidationResult validate(KafkaConsumerConnection kafkaConsumerConnection) {
        if (kafkaConsumerConnection.getMuleConsumer() != null) {
            return ConnectionValidationResult.success();
        }
        return ConnectionValidationResult.failure((String)"Connection is no longer valid", null);
    }

    protected List<Consumer<?, ?>> getConsumers(Properties consumerProperties) {
        ArrayList kafkaConsumers = new ArrayList();
        for (int i = 0; i < this.consumerParamsGoup.getConsumerPartitions(); ++i) {
            kafkaConsumers.add((Consumer<?, ?>)new KafkaConsumer(consumerProperties));
        }
        return kafkaConsumers;
    }
}

