/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.kafka.internal.connection.provider.decorator;

import java.util.Map;
import java.util.Optional;
import java.util.Properties;

public interface ConnectionProviderDecorator {
    default public void setProperty(Properties properties, String key, String value) {
        Optional.ofNullable(Optional.ofNullable(value).orElse(properties.getProperty(key))).ifPresent(property -> properties.setProperty(key, (String)property));
    }

    default public void setProperties(Properties properties, Map<String, String> toBeAdded) {
        toBeAdded.forEach((key, value) -> this.setProperty(properties, (String)key, (String)value));
    }

    default public String resolveFilename(String filename) {
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        return Optional.ofNullable(contextClassLoader.getResource(filename)).orElseThrow(() -> new IllegalArgumentException("File not found: " + filename)).getPath();
    }
}

