/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.kafka.internal.connection.provider.decorator;

import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.mule.modules.kafka.internal.connection.provider.decorator.ConnectionProviderDecorator;
import org.mule.modules.kafka.internal.connection.provider.param.KerberosParamsGroup;

public interface KerberosDecorator
extends ConnectionProviderDecorator {
    default public void onPropertyBuilt(Properties properties, KerberosParamsGroup kerberosParams) {
        if (StringUtils.isNotEmpty((CharSequence)kerberosParams.getKerberosConfigFile())) {
            System.setProperty("java.security.krb5.conf", this.resolveFilename(kerberosParams.getKerberosConfigFile()));
        }
        this.setProperty(properties, "sasl.mechanism", "GSSAPI");
        this.setProperty(properties, "sasl.kerberos.service.name", kerberosParams.getServiceName());
        StringBuilder builder = new StringBuilder("com.sun.security.auth.module.Krb5LoginModule required ");
        builder.append("keyTab=").append(this.quote(this.resolveFilename(kerberosParams.getKeytab()))).append(" ");
        builder.append("principal=").append(this.quote(kerberosParams.getPrincipal())).append(" ");
        builder.append("useKeyTab=").append(this.quote("true"));
        if (!kerberosParams.getAdditionalJAASProperties().isEmpty()) {
            builder.append(" ");
            String additionalProps = kerberosParams.getAdditionalJAASProperties().entrySet().stream().map(entry -> (String)entry.getKey() + "=" + this.quote((String)entry.getValue())).collect(Collectors.joining(" "));
            builder.append(additionalProps);
        }
        builder.append(";");
        this.setProperty(properties, "sasl.jaas.config", builder.toString());
    }

    default public String quote(String valueToQuote) {
        return "\"" + valueToQuote + "\"";
    }
}

