/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.kafka.internal.connection.provider.decorator;

import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.mule.modules.kafka.internal.connection.provider.decorator.ConnectionProviderDecorator;
import org.mule.modules.kafka.internal.connection.provider.param.SSLParamsGroup;
import org.mule.runtime.api.connection.ConnectionException;

public interface SSLDecorator
extends ConnectionProviderDecorator {
    default public void onBuiltProperties(Properties properties, SSLParamsGroup sslParams) throws ConnectionException {
        this.setProperty(properties, "security.protocol", "SSL");
        if (StringUtils.isNotEmpty((CharSequence)sslParams.getKeyStoreLocation())) {
            this.setPathProperty(properties, "ssl.keystore.location", sslParams.getKeyStoreLocation());
            if (StringUtils.isEmpty((CharSequence)sslParams.getKeyStorePassword())) {
                throw new IllegalArgumentException("Keystore password is required when keystore location is provided.");
            }
            this.setProperty(properties, "ssl.keystore.password", sslParams.getKeyStorePassword());
        }
        this.setProperty(properties, "ssl.keystore.type", sslParams.getKeyStoreType());
        this.setPathProperty(properties, "ssl.truststore.location", sslParams.getTrustStoreLocation());
        this.setProperty(properties, "ssl.truststore.password", sslParams.getTrustStorePassword());
        this.setProperty(properties, "ssl.truststore.type", sslParams.getTrustStoreType());
    }

    default public void setPathProperty(Properties properties, String key, String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            throw new IllegalArgumentException("Value for key: \"" + key + "\" cannot be null or empty.");
        }
        this.setProperty(properties, key, this.resolveFilename(filename));
    }
}

