/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.kafka.internal.service;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.mule.modules.kafka.internal.error.KafkaErrorType;
import org.mule.modules.kafka.internal.error.exception.UnableToSendMessageToTopicException;

public class MuleProducer {
    private Producer<Object, Object> producer;

    public MuleProducer(Producer<Object, Object> producer) {
        this.producer = producer;
    }

    public void send(String topic, Object key, Object message) {
        try {
            Future futureResult = this.producer.send(new ProducerRecord(topic, key, message));
            futureResult.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new UnableToSendMessageToTopicException("Producer unable to send message to topic.", e, KafkaErrorType.UNABLE_TO_SEND_MESSAGE);
        }
    }

    public void shutdown() {
        this.producer.close();
    }
}

