/*
 * Decompiled with CFR 0.152.
 */
package org.mule.modules.kafka.internal.sources;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.modules.kafka.api.Offset;
import org.mule.modules.kafka.internal.connection.KafkaConsumerConnection;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Streaming;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.source.EmitsResponse;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

@DisplayName(value="Consumer")
@Alias(value="consumer")
@EmitsResponse
@Streaming
@MediaType(value="*/*")
public class KafkaSource
extends Source<String, Serializable> {
    @Connection
    private ConnectionProvider<KafkaConsumerConnection> provider;
    private KafkaConsumerConnection connection;
    @Parameter
    private String topic;
    @Parameter
    @Optional
    @NullSafe
    private List<Offset> partitionOffsets;

    public void onStart(SourceCallback<String, Serializable> sourceCallback) throws MuleException {
        this.connection = (KafkaConsumerConnection)this.provider.connect();
        Map<String, String> offsets = this.partitionOffsets.stream().collect(Collectors.toMap(Offset::getPartitionNumber, Offset::getPartitionOffset));
        this.connection.getMuleConsumer().run(sourceCallback, this.topic, offsets);
    }

    public void onStop() {
        this.provider.disconnect((Object)this.connection);
    }

    public List<Offset> getPartitionOffsets() {
        return this.partitionOffsets;
    }

    public void setPartitionOffsets(List<Offset> partitionOffsets) {
        this.partitionOffsets = partitionOffsets;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }
}

