/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.api;

import com.mulesoft.connectors.kafka.api.ByteArrayInputStreamWrapper;
import com.mulesoft.connectors.kafka.api.source.ConsumerContext;
import com.mulesoft.connectors.kafka.internal.util.ExcludeFromGeneratedCoverage;
import java.io.InputStream;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Objects;
import org.mule.runtime.core.api.util.IOUtils;

public class KafkaRecordAttributes
extends ConsumerContext
implements Serializable {
    private String topic;
    private int partition;
    private Map<String, byte[]> headers;
    private transient InputStream key;
    private long offset;
    private ZonedDateTime creationTimestamp;
    private ZonedDateTime logAppendTimestamp;
    private Integer serializedKeySize;
    private Integer serializedValueSize;
    private Integer leaderEpoch;

    public KafkaRecordAttributes() {
    }

    public KafkaRecordAttributes(String consumerCommitKey, String topic, int partition, Map<String, byte[]> headers, InputStream key, long offset, ZonedDateTime creationTimestamp, ZonedDateTime logAppendTimestamp, Integer serializedKeySize, Integer serializedValueSize, Integer leaderEpoch) {
        super(consumerCommitKey);
        this.topic = topic;
        this.partition = partition;
        this.headers = headers;
        this.key = key != null ? new ByteArrayInputStreamWrapper(IOUtils.toByteArray((InputStream)key)) : null;
        this.offset = offset;
        this.creationTimestamp = creationTimestamp;
        this.logAppendTimestamp = logAppendTimestamp;
        this.serializedKeySize = serializedKeySize;
        this.serializedValueSize = serializedValueSize;
        this.leaderEpoch = leaderEpoch;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public Map<String, byte[]> getHeaders() {
        return this.headers;
    }

    public InputStream getKey() {
        return this.key != null ? ((ByteArrayInputStreamWrapper)this.key).getKey() : null;
    }

    public long getOffset() {
        return this.offset;
    }

    public ZonedDateTime getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public ZonedDateTime getLogAppendTimestamp() {
        return this.logAppendTimestamp;
    }

    public Integer getSerializedKeySize() {
        return this.serializedKeySize;
    }

    public Integer getSerializedValueSize() {
        return this.serializedValueSize;
    }

    public Integer getLeaderEpoch() {
        return this.leaderEpoch;
    }

    @ExcludeFromGeneratedCoverage
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @ExcludeFromGeneratedCoverage
    public void setPartition(int partition) {
        this.partition = partition;
    }

    @ExcludeFromGeneratedCoverage
    public void setHeaders(Map<String, byte[]> headers) {
        this.headers = headers;
    }

    @ExcludeFromGeneratedCoverage
    public void setKey(InputStream key) {
        this.key = key;
    }

    @ExcludeFromGeneratedCoverage
    public void setOffset(long offset) {
        this.offset = offset;
    }

    @ExcludeFromGeneratedCoverage
    public void setCreationTimestamp(ZonedDateTime creationTimestamp) {
        this.creationTimestamp = creationTimestamp;
    }

    @ExcludeFromGeneratedCoverage
    public void setLogAppendTimestamp(ZonedDateTime logAppendTimestamp) {
        this.logAppendTimestamp = logAppendTimestamp;
    }

    @ExcludeFromGeneratedCoverage
    public void setSerializedKeySize(Integer serializedKeySize) {
        this.serializedKeySize = serializedKeySize;
    }

    @ExcludeFromGeneratedCoverage
    public void setSerializedValueSize(Integer serializedValueSize) {
        this.serializedValueSize = serializedValueSize;
    }

    @ExcludeFromGeneratedCoverage
    public void setLeaderEpoch(Integer leaderEpoch) {
        this.leaderEpoch = leaderEpoch;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KafkaRecordAttributes that = (KafkaRecordAttributes)o;
        return this.partition == that.partition && this.offset == that.offset && Objects.equals(this.topic, that.topic) && Objects.equals(this.headers, that.headers) && Objects.equals(this.key, that.key) && Objects.equals(this.creationTimestamp, that.creationTimestamp) && Objects.equals(this.logAppendTimestamp, that.logAppendTimestamp) && Objects.equals(this.serializedKeySize, that.serializedKeySize) && Objects.equals(this.serializedValueSize, that.serializedValueSize) && Objects.equals(this.leaderEpoch, that.leaderEpoch);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.topic, this.partition, this.headers, this.key, this.offset, this.creationTimestamp, this.logAppendTimestamp, this.serializedKeySize, this.serializedValueSize, this.leaderEpoch);
    }
}

