/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.api.connection.provider;

import com.mulesoft.connectors.kafka.internal.util.ExcludeFromGeneratedCoverage;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@DisplayName(value="Fetch configuration")
public class KafkaFetchParamGroup
implements Serializable {
    @Parameter
    @Summary(value="TCP buffer size for sending data.")
    @Example(value="1")
    @Optional(defaultValue="1")
    @DisplayName(value="Default fetch minimum size")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Integer fetchMinimumSize;
    @Parameter
    @Optional(defaultValue="BYTE")
    @Example(value="BYTE")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private DataUnit fetchMinimumSizeUnit;
    @Parameter
    @Summary(value="Maximum response size.")
    @Example(value="50")
    @Optional(defaultValue="1")
    @DisplayName(value="Default fetch maximum size")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Integer fetchMaximumSize;
    @Parameter
    @Summary(value="The maximum partition fetch size unit of measure.")
    @Example(value="MB")
    @Optional(defaultValue="MB")
    @DisplayName(value="Default maximum fetch size unit")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private DataUnit fetchMaximumSizeUnit;
    @Parameter
    @Summary(value="The maximum size of fetched records.")
    @Example(value="1")
    @Optional(defaultValue="1")
    @DisplayName(value="Default maximum partition fetch size")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Integer maximumPartitionFetchSize;
    @Parameter
    @Summary(value="The maximum partition fetch size unit of measure.")
    @Optional(defaultValue="MB")
    @Example(value="MB")
    @DisplayName(value="Default maximum partition fetch unit")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private DataUnit maximumPartitionFetchSizeUnit;
    @Parameter
    @Summary(value="The maximum amount of time the server will block before answering the fetch request.\n")
    @Example(value="500")
    @Optional(defaultValue="500")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int fetchMaximumWaitTimeout;
    @Parameter
    @Summary(value="Determines the time unit for fetch maximum wait timeout scalar.")
    @Example(value="MILLISECONDS")
    @Optional(defaultValue="MILLISECONDS")
    @Placement(tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit fetchMaximumWaitTimeoutUnit;

    public Integer getFetchMinimumSize() {
        return this.fetchMinimumSize;
    }

    public DataUnit getFetchMinimumSizeUnit() {
        return this.fetchMinimumSizeUnit;
    }

    public Integer getFetchMaximumSize() {
        return this.fetchMaximumSize;
    }

    public DataUnit getFetchMaximumSizeUnit() {
        return this.fetchMaximumSizeUnit;
    }

    public Integer getMaximumPartitionFetchSize() {
        return this.maximumPartitionFetchSize;
    }

    public DataUnit getMaximumPartitionFetchSizeUnit() {
        return this.maximumPartitionFetchSizeUnit;
    }

    public int getFetchMaximumWaitTimeout() {
        return this.fetchMaximumWaitTimeout;
    }

    public TimeUnit getFetchMaximumWaitTimeoutUnit() {
        return this.fetchMaximumWaitTimeoutUnit;
    }

    @ExcludeFromGeneratedCoverage
    public void setFetchMinimumSize(Integer fetchMinimumSize) {
        this.fetchMinimumSize = fetchMinimumSize;
    }

    @ExcludeFromGeneratedCoverage
    public void setFetchMinimumSizeUnit(DataUnit fetchMinimumSizeUnit) {
        this.fetchMinimumSizeUnit = fetchMinimumSizeUnit;
    }

    @ExcludeFromGeneratedCoverage
    public void setFetchMaximumSize(Integer fetchMaximumSize) {
        this.fetchMaximumSize = fetchMaximumSize;
    }

    @ExcludeFromGeneratedCoverage
    public void setFetchMaximumSizeUnit(DataUnit fetchMaximumSizeUnit) {
        this.fetchMaximumSizeUnit = fetchMaximumSizeUnit;
    }

    @ExcludeFromGeneratedCoverage
    public void setMaximumPartitionFetchSize(Integer maximumPartitionFetchSize) {
        this.maximumPartitionFetchSize = maximumPartitionFetchSize;
    }

    @ExcludeFromGeneratedCoverage
    public void setMaximumPartitionFetchSizeUnit(DataUnit maximumPartitionFetchSizeUnit) {
        this.maximumPartitionFetchSizeUnit = maximumPartitionFetchSizeUnit;
    }

    @ExcludeFromGeneratedCoverage
    public void setFetchMaximumWaitTimeout(int fetchMaximumWaitTimeout) {
        this.fetchMaximumWaitTimeout = fetchMaximumWaitTimeout;
    }

    @ExcludeFromGeneratedCoverage
    public void setFetchMaximumWaitTimeoutUnit(TimeUnit fetchMaximumWaitTimeoutUnit) {
        this.fetchMaximumWaitTimeoutUnit = fetchMaximumWaitTimeoutUnit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KafkaFetchParamGroup that = (KafkaFetchParamGroup)o;
        return this.fetchMaximumWaitTimeout == that.fetchMaximumWaitTimeout && Objects.equals(this.fetchMinimumSize, that.fetchMinimumSize) && this.fetchMinimumSizeUnit == that.fetchMinimumSizeUnit && Objects.equals(this.fetchMaximumSize, that.fetchMaximumSize) && this.fetchMaximumSizeUnit == that.fetchMaximumSizeUnit && Objects.equals(this.maximumPartitionFetchSize, that.maximumPartitionFetchSize) && this.maximumPartitionFetchSizeUnit == that.maximumPartitionFetchSizeUnit && this.fetchMaximumWaitTimeoutUnit == that.fetchMaximumWaitTimeoutUnit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.fetchMaximumWaitTimeout, this.fetchMinimumSize, this.fetchMinimumSizeUnit, this.fetchMaximumSize, this.fetchMaximumSizeUnit, this.maximumPartitionFetchSize, this.maximumPartitionFetchSizeUnit, this.fetchMaximumWaitTimeoutUnit});
    }
}

