/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.api.connection.provider;

import com.mulesoft.connectors.kafka.internal.util.ExcludeFromGeneratedCoverage;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.display.PathModel;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Path;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class KerberosConnectionParams {
    public static final String PARAM_GROUP_NAME = "SASL/GSSAPI";
    @Parameter
    @DisplayName(value="Principal")
    @Summary(value="A principal in computer security is an entity that can be authenticated by a computer system or network.")
    @Example(value="clntconfig/admin@EXAMPLE.COM")
    @Placement(order=1)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String principal;
    @Parameter
    @DisplayName(value="Service name")
    @Summary(value="The Kerberos principal name that Kafka runs as.")
    @Example(value="kafka")
    @Placement(order=2)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String serviceName;
    @Parameter
    @Optional
    @DisplayName(value="Kerberos configuration file (krb5.conf)")
    @Summary(value="The krb5.conf file contains Kerberos configuration information.")
    @Placement(order=3)
    @Path(type=PathModel.Type.FILE, acceptedFileExtensions={".conf"}, location=PathModel.Location.EXTERNAL)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String krb5ConfPath;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Use ticket cache")
    @Summary(value="Set this to true, if you want the TGT to be obtained from the ticket cache.")
    @Placement(order=100, tab="Advanced")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean useTicketCache;
    @Parameter
    @Optional
    @DisplayName(value="Ticket cache")
    @Summary(value="Set this to the name of the ticket cache that contains the user's TGT.")
    @Example(value="DEFCCNAME")
    @Placement(order=101, tab="Advanced")
    @Path(type=PathModel.Type.FILE, location=PathModel.Location.EXTERNAL)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String ticketCache;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Use keytab")
    @Placement(order=1, tab="Security")
    @Summary(value="Set this to true if you want the module to get the principal's key from the the keytab.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean useKeytab;
    @Parameter
    @Optional
    @DisplayName(value="Keytab")
    @Placement(order=2, tab="Security")
    @Summary(value="Set this to the file name of the keytab to get the principal's secret key.")
    @Path(type=PathModel.Type.FILE, acceptedFileExtensions={".keytab"}, location=PathModel.Location.EXTERNAL)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String keytab;
    @Parameter
    @Optional(defaultValue="false")
    @DisplayName(value="Store key")
    @Placement(order=3, tab="Security")
    @Summary(value="Set this to true if you want the principal's key to be stored in the Subject's private credentials.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean storeKey;

    public String getServiceName() {
        return this.serviceName;
    }

    public String getKeytab() {
        return this.keytab;
    }

    public String getKrb5ConfPath() {
        return this.krb5ConfPath;
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getTicketCache() {
        return this.ticketCache;
    }

    public boolean isStoreKey() {
        return this.storeKey;
    }

    public boolean isUseKeytab() {
        return this.useKeytab;
    }

    public boolean isUseTicketCache() {
        return this.useTicketCache;
    }

    @ExcludeFromGeneratedCoverage
    public void setPrincipal(String principal) {
        this.principal = principal;
    }

    @ExcludeFromGeneratedCoverage
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @ExcludeFromGeneratedCoverage
    public void setKrb5ConfPath(String krb5ConfPath) {
        this.krb5ConfPath = krb5ConfPath;
    }

    @ExcludeFromGeneratedCoverage
    public void setUseTicketCache(boolean useTicketCache) {
        this.useTicketCache = useTicketCache;
    }

    @ExcludeFromGeneratedCoverage
    public void setTicketCache(String ticketCache) {
        this.ticketCache = ticketCache;
    }

    @ExcludeFromGeneratedCoverage
    public void setUseKeytab(boolean useKeytab) {
        this.useKeytab = useKeytab;
    }

    @ExcludeFromGeneratedCoverage
    public void setKeytab(String keytab) {
        this.keytab = keytab;
    }

    @ExcludeFromGeneratedCoverage
    public void setStoreKey(boolean storeKey) {
        this.storeKey = storeKey;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KerberosConnectionParams that = (KerberosConnectionParams)o;
        return this.useTicketCache == that.useTicketCache && this.useKeytab == that.useKeytab && this.storeKey == that.storeKey && Objects.equals(this.principal, that.principal) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.krb5ConfPath, that.krb5ConfPath) && Objects.equals(this.ticketCache, that.ticketCache) && Objects.equals(this.keytab, that.keytab);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.serviceName, this.krb5ConfPath, this.useTicketCache, this.ticketCache, this.useKeytab, this.keytab, this.storeKey);
    }
}

