/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.api.connection.provider;

import com.mulesoft.connectors.kafka.api.connection.provider.ScramEncryptionType;
import com.mulesoft.connectors.kafka.internal.util.ExcludeFromGeneratedCoverage;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public class TokenConnectionParams {
    public static final String PARAM_GROUP_NAME = "SASL/TOKEN";
    @Parameter
    @Summary(value="The token ID used for authenticating the client.")
    @DisplayName(value="Token ID")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(order=1)
    private String tokenID;
    @Parameter
    @Summary(value="The value of the token HMAC.")
    @DisplayName(value="Token HMAC")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(order=2)
    private String tokenHMAC;
    @Parameter
    @Summary(value="The encryption algorithm used by SCRAM.")
    @DisplayName(value="Encryption type")
    @Placement(order=3)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ScramEncryptionType encryptionType;

    public String getTokenID() {
        return this.tokenID;
    }

    public String getTokenHMAC() {
        return this.tokenHMAC;
    }

    public ScramEncryptionType getEncryptionType() {
        return this.encryptionType;
    }

    @ExcludeFromGeneratedCoverage
    public void setTokenID(String tokenID) {
        this.tokenID = tokenID;
    }

    @ExcludeFromGeneratedCoverage
    public void setTokenHMAC(String tokenHMAC) {
        this.tokenHMAC = tokenHMAC;
    }

    @ExcludeFromGeneratedCoverage
    public void setEncryptionType(ScramEncryptionType encryptionType) {
        this.encryptionType = encryptionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TokenConnectionParams that = (TokenConnectionParams)o;
        return Objects.equals(this.tokenID, that.tokenID) && Objects.equals(this.tokenHMAC, that.tokenHMAC) && this.encryptionType == that.encryptionType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.tokenID, this.tokenHMAC, this.encryptionType});
    }
}

