/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.api.params;

import com.mulesoft.connectors.kafka.api.source.TopicPartition;
import com.mulesoft.connectors.kafka.internal.util.ExcludeFromGeneratedCoverage;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.ExclusiveOptionals;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

@ExclusiveOptionals(isOneRequired=true)
public class SubscriptionParamGroup
implements Serializable {
    @NullSafe
    @Parameter
    @Summary(value="The list of subscription regular expressions to subscribe to. This topics will be automatically rebalanced between the amount of consumers of the topic.")
    @Example(value="[\"topic1\",\".*topicX.*]]")
    @DisplayName(value="Topic Subscription Patterns")
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<String> topicPatterns;
    @NullSafe
    @Parameter
    @Summary(value="The list of topic-partition pairs to assign. Note that there will be no automatic rebalance of the consumers ")
    @Example(value="[\"topic1\",\".*topicX.*]]")
    @DisplayName(value="Assignments")
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private List<TopicPartition> assignments;

    public List<String> getTopicPatterns() {
        return this.topicPatterns;
    }

    public List<TopicPartition> getAssignments() {
        return this.assignments;
    }

    @ExcludeFromGeneratedCoverage
    public void setTopicPatterns(List<String> topicPatterns) {
        this.topicPatterns = topicPatterns;
    }

    @ExcludeFromGeneratedCoverage
    public void setAssignments(List<TopicPartition> assignments) {
        this.assignments = assignments;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubscriptionParamGroup that = (SubscriptionParamGroup)o;
        return this.topicPatterns == that.topicPatterns && this.assignments == that.assignments;
    }

    public int hashCode() {
        return Objects.hash(this.assignments, this.topicPatterns);
    }
}

