/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.internal.config;

import com.mulesoft.connectors.commons.template.config.ConnectorConfig;
import com.mulesoft.connectors.kafka.api.operation.KafkaMessageMetadata;
import com.mulesoft.connectors.kafka.internal.connection.provider.plaintext.PlaintextProducerConnectionProvider;
import com.mulesoft.connectors.kafka.internal.connection.provider.sasl.kerberos.KerberosProducerConnectionProvider;
import com.mulesoft.connectors.kafka.internal.connection.provider.sasl.plain.PlainProducerConnectionProvider;
import com.mulesoft.connectors.kafka.internal.connection.provider.sasl.scram.ScramProducerConnectionProvider;
import com.mulesoft.connectors.kafka.internal.connection.provider.sasl.token.TokenProducerConnectionProvider;
import com.mulesoft.connectors.kafka.internal.operation.PublishOperation;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Date;
import java.util.Optional;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.mule.runtime.extension.api.annotation.Configuration;
import org.mule.runtime.extension.api.annotation.Operations;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.runtime.operation.Result;

@Operations(value={PublishOperation.class})
@ConnectionProviders(value={PlaintextProducerConnectionProvider.class, ScramProducerConnectionProvider.class, KerberosProducerConnectionProvider.class, PlainProducerConnectionProvider.class, TokenProducerConnectionProvider.class})
@Configuration(name="producer-config")
@DisplayName(value="Producer configuration")
public class ProducerConfiguration
implements ConnectorConfig {
    @Parameter
    @Placement(order=1)
    @Summary(value="A default topic name.")
    @Example(value="test-topic")
    @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="defaultTopicName")
    @DisplayName(value="Default topic")
    private String topic;
    @Parameter
    @org.mule.runtime.extension.api.annotation.param.Optional
    @Placement(tab="Advanced", order=1)
    @DisplayName(value="Zone ID")
    private String zoneId;

    public String getTopic() {
        return this.topic;
    }

    public Result<KafkaMessageMetadata, Void> parseMetadata(RecordMetadata metadata) {
        if (metadata == null) {
            return null;
        }
        return Result.builder().output((Object)new KafkaMessageMetadata(metadata.topic(), metadata.partition(), metadata.offset(), ZonedDateTime.ofInstant(new Date(metadata.timestamp()).toInstant(), Optional.ofNullable(this.zoneId).map(ZoneId::of).orElseGet(ZoneId::systemDefault)), metadata.serializedKeySize(), metadata.serializedValueSize())).build();
    }
}

