/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.internal.connection.provider;

import com.mulesoft.connectors.kafka.api.connection.provider.ClientDNSLookup;
import com.mulesoft.connectors.kafka.api.connection.provider.CompressionType;
import com.mulesoft.connectors.kafka.api.connection.provider.Partitioner;
import com.mulesoft.connectors.kafka.api.connection.provider.ProducerAck;
import com.mulesoft.connectors.kafka.internal.connection.ProducerConnection;
import com.mulesoft.connectors.kafka.internal.connection.provider.KafkaConnectionProvider;
import com.mulesoft.connectors.kafka.internal.error.exception.KafkaModuleException;
import com.mulesoft.connectors.kafka.internal.model.serializer.InputStreamSerializer;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.RoundRobinPartitioner;
import org.apache.kafka.clients.producer.UniformStickyPartitioner;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.util.DataUnit;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Example;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;

public abstract class ProducerConnectionProvider
extends KafkaConnectionProvider<ProducerConnection> {
    @Parameter
    @Placement(order=1, tab="Advanced")
    @Summary(value="Controls the default batch size in bytes.")
    @Optional(defaultValue="16")
    @DisplayName(value="Batch size")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Integer batchSize;
    @Parameter
    @Placement(order=2, tab="Advanced")
    @Optional(defaultValue="KB")
    @DisplayName(value="The batch size unit of measure.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private DataUnit batchSizeUnit;
    @Parameter
    @Placement(order=3, tab="Advanced")
    @Summary(value="The total bytes of memory the producer can use to buffer records waiting to be sent to the server.")
    @Optional(defaultValue="1000")
    @DisplayName(value="Buffer size")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Integer bufferSize;
    @Parameter
    @Placement(order=4, tab="Advanced")
    @Optional(defaultValue="KB")
    @DisplayName(value="The buffer memory size unit of measure.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private DataUnit bufferSizeUnit;
    @Parameter
    @Placement(order=5, tab="Advanced")
    @DisplayName(value="DNS lookups")
    @Summary(value="Controls how the client uses DNS lookups")
    @Optional(defaultValue="USE_ALL_DNS_IPS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ClientDNSLookup clientDNSLookup;
    @Parameter
    @Placement(order=6, tab="Advanced")
    @DisplayName(value="Compression type")
    @Summary(value="The compression type for all data generated by the producer.")
    @Optional(defaultValue="NONE")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private CompressionType compressionType;
    @Parameter
    @Placement(order=7, tab="Advanced")
    @Summary(value="Specifies the number of milliseconds after which the idle connections will be closed.")
    @DisplayName(value="Connections maximum idle time")
    @Optional(defaultValue="540")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int connectionsMaximumIdleTimeout;
    @Parameter
    @Placement(order=8, tab="Advanced")
    @Summary(value="Time unit for connections maximum idle.")
    @DisplayName(value="Connections maximum idle time unit")
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit connectionsMaximumIdleTimeUnit;
    @Parameter
    @Placement(order=9, tab="Advanced")
    @Summary(value="An upper bound on the time to report success or failure after a call to send().")
    @DisplayName(value="Delivery timeout")
    @Optional(defaultValue="120")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int deliveryTimeout;
    @Parameter
    @Placement(order=10, tab="Advanced")
    @Summary(value="Time unit for delivery timeout.")
    @Example(value="SECONDS")
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit deliveryTimeoutTimeUnit;
    @Parameter
    @Placement(order=11, tab="Advanced")
    @DisplayName(value="Enable idempotence")
    @Summary(value="Enable idempotence on producer instance.")
    @Optional(defaultValue="false")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private boolean idempotence;
    @Parameter
    @Placement(order=12, tab="Advanced")
    @Summary(value="The upper bound of time to wait for batch size of records before sending.")
    @DisplayName(value="Linger time ")
    @Optional(defaultValue="0")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int lingerTime;
    @Parameter
    @Placement(order=13, tab="Advanced")
    @Summary(value="Time unit for linger time.")
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit lingerTimeUnit;
    @Parameter
    @Placement(order=14, tab="Advanced")
    @Summary(value="The configuration controls how long KafkaProducer.send() and KafkaProducer.partitionsFor() will block.")
    @DisplayName(value="Maximum block time ")
    @Optional(defaultValue="60")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int maximumBlockTime;
    @Parameter
    @Placement(order=15, tab="Advanced")
    @Summary(value="Time unit for maximum block time.")
    @DisplayName(value="Maximum block time unit")
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit maximumBlockTimeUnit;
    @Parameter
    @Placement(order=16, tab="Advanced")
    @Summary(value="The maximum number of unacknowledged requests the client will send on a single connection before blocking.")
    @Optional(defaultValue="5")
    @DisplayName(value="Maximum in flight requests")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int maximumInFlightRequests;
    @Parameter
    @Placement(order=17, tab="Advanced")
    @Summary(value="The maximum size of a request in bytes.")
    @Optional(defaultValue="1")
    @DisplayName(value="Maximum request size")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Integer maximumRequestSize;
    @Parameter
    @Placement(order=18, tab="Advanced")
    @Summary(value="The maximum request size unit of measure.")
    @Optional(defaultValue="MB")
    @DisplayName(value="Maximum request size unit.")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private DataUnit maximumRequestSizeUnit;
    @Parameter
    @Placement(order=19, tab="Advanced")
    @DisplayName(value="Producer acknowledge mode")
    @Summary(value="The number of acknowledgments the producer requires the leader to have received before considering a request complete.")
    @Example(value="ALL")
    @Optional(defaultValue="NONE")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private ProducerAck producerAck;
    @Parameter
    @Placement(order=20, tab="Advanced")
    @Summary(value="TCP buffer size to receive data.")
    @Optional(defaultValue="64")
    @DisplayName(value="Default receive buffer size")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Integer receiveBufferSize;
    @Parameter
    @Placement(order=21, tab="Advanced")
    @Optional(defaultValue="KB")
    @DisplayName(value="Default receive buffer size unit")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private DataUnit receiveBufferSizeUnit;
    @Parameter
    @Placement(order=22, tab="Advanced")
    @DisplayName(value="Retries amount")
    @Summary(value="How many times to retry sending a batch.")
    @Optional(defaultValue="1")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int retries;
    @Parameter
    @Placement(order=24, tab="Advanced")
    @Summary(value="The retry backoff timeout time unit.")
    @Example(value="MILLISECONDS")
    @Optional(defaultValue="MILLISECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit retryBackoffTimeoutTimeUnit;
    @Parameter
    @Placement(order=23, tab="Advanced")
    @Summary(value="The time to wait before attempting to retry a failed request to a given topic partition.")
    @DisplayName(value="Retry backoff timeout")
    @Optional(defaultValue="100")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private long retryBackoffTimeout;
    @Parameter
    @Placement(order=25, tab="Advanced")
    @Summary(value="TCP buffer size for sending data.")
    @Optional(defaultValue="128")
    @DisplayName(value="Default send buffer size")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Integer sendBufferSize;
    @Parameter
    @Placement(order=26, tab="Advanced")
    @Summary(value="The send buffer size unit of measure.")
    @Optional(defaultValue="KB")
    @Example(value="KB")
    @DisplayName(value="Default send buffer size unit")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private DataUnit sendBufferSizeUnit;
    @Parameter
    @Placement(order=28, tab="Advanced")
    @Summary(value="The request timeout time unit.")
    @Optional(defaultValue="SECONDS")
    @DisplayName(value="Default request timeout time unit")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private TimeUnit requestTimeoutTimeUnit;
    @Parameter
    @Placement(order=27, tab="Advanced")
    @Summary(value="The maximum amount of time the client will wait for the response of a request.")
    @Optional(defaultValue="30")
    @DisplayName(value="Default request timeout")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private int requestTimeout;
    @Parameter
    @Placement(order=28, tab="Advanced")
    @Summary(value="The partitioning strategy to use for messages.")
    @Optional(defaultValue="DEFAULT")
    @DisplayName(value="Partitioner")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private Partitioner partitioner;
    private KafkaProducer<InputStream, InputStream> defaultProducer;

    public ProducerConnectionProvider(SecurityProtocol plainProtocol, SecurityProtocol sslProtocol) {
        super(plainProtocol, sslProtocol);
    }

    @Override
    public ProducerConnection connect(Properties properties) {
        return new ProducerConnection((Producer<InputStream, InputStream>)this.defaultProducer, properties);
    }

    @Override
    protected void initialise(Properties properties) throws InitialisationException {
        try {
            this.setPropertyAsString("key.serializer", InputStreamSerializer.class.getName());
            this.setPropertyAsString("value.serializer", InputStreamSerializer.class.getName());
            this.setPropertyAsString("receive.buffer.bytes", this.receiveBufferSizeUnit.toBytes(this.receiveBufferSize.intValue()));
            this.setPropertyAsString("send.buffer.bytes", this.sendBufferSizeUnit.toBytes(this.sendBufferSize.intValue()));
            this.setPropertyAsString("retry.backoff.ms", String.valueOf(TimeUnit.MILLISECONDS.convert(this.retryBackoffTimeout, this.retryBackoffTimeoutTimeUnit)));
            this.setPropertyAsString("acks", this.getMappedValue((Object)((Object)this.producerAck), (Object)"0", (Function)this.map(ProducerAck.ALL, "-1"), (Function)this.map(ProducerAck.LEADER_ONLY, "1"), (Function)this.map(ProducerAck.NONE, "0")));
            this.setPropertyAsString("request.timeout.ms", String.valueOf(TimeUnit.MILLISECONDS.convert(this.requestTimeout, this.requestTimeoutTimeUnit)));
            this.setPropertyAsString("batch.size", this.batchSizeUnit.toBytes(this.batchSize.intValue()));
            this.setPropertyAsString("buffer.memory", this.bufferSizeUnit.toBytes(this.bufferSize.intValue()));
            this.setPropertyAsString("client.dns.lookup", this.clientDNSLookup.getLookupType());
            this.setPropertyAsString("compression.type", this.compressionType.name().toLowerCase());
            this.setPropertyAsString("connections.max.idle.ms", (int)this.connectionsMaximumIdleTimeUnit.toMillis(this.connectionsMaximumIdleTimeout));
            this.setPropertyAsString("delivery.timeout.ms", (int)this.deliveryTimeoutTimeUnit.toMillis(this.deliveryTimeout));
            this.setPropertyAsString("enable.idempotence", this.idempotence);
            this.setPropertyAsString("linger.ms", (int)this.lingerTimeUnit.toMillis(this.lingerTime));
            this.setPropertyAsString("max.block.ms", (int)this.maximumBlockTimeUnit.toMillis(this.maximumBlockTime));
            this.setPropertyAsString("max.in.flight.requests.per.connection", this.maximumInFlightRequests);
            this.setPropertyAsString("max.request.size", this.maximumRequestSizeUnit.toBytes(this.maximumRequestSize.intValue()));
            this.setPropertyAsString("retries", this.retries);
            this.setPropertyAsString("partitioner.class", this.getMappedValue((Object)((Object)this.partitioner), (Object)DefaultPartitioner.class.getName(), (Function)this.map(Partitioner.DEFAULT, DefaultPartitioner.class.getName()), (Function)this.map(Partitioner.ROUND_ROBIN, RoundRobinPartitioner.class.getName()), (Function)this.map(Partitioner.UNIFORM_STICKY, UniformStickyPartitioner.class.getName())));
            this.onBeforeDefaultProducerCreation(properties);
            this.defaultProducer = new KafkaProducer(properties);
        }
        catch (KafkaException e) {
            this.handleConnectionException(e);
        }
    }

    private <T, V> Function<T, V> map(T val, V mappedVal) {
        return e -> val.equals(e) ? mappedVal : null;
    }

    @SafeVarargs
    private final <T, V> V getMappedValue(T val, V defaultValue, Function<T, V> ... values) {
        return (V)(val == null ? defaultValue : Stream.of(values).filter(value -> value.apply(val) != null).findFirst().get().apply(val));
    }

    protected void onBeforeDefaultProducerCreation(Properties properties) throws InitialisationException {
    }

    public void dispose() {
        try {
            if (this.defaultProducer != null) {
                this.defaultProducer.close();
            }
        }
        catch (KafkaModuleException e) {
            throw new MuleRuntimeException((Throwable)((Object)e));
        }
    }
}

