/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.internal.connection.provider.sasl.kerberos;

import com.mulesoft.connectors.kafka.api.connection.provider.KerberosConnectionParams;
import com.mulesoft.connectors.kafka.internal.error.exception.EmptyKeytabPathException;
import com.mulesoft.connectors.kafka.internal.error.exception.EmptyTicketCachePathException;
import com.mulesoft.connectors.kafka.internal.error.exception.InvalidConfigurationException;
import com.mulesoft.connectors.kafka.internal.error.exception.KeytabNotFoundException;
import com.mulesoft.connectors.kafka.internal.error.exception.KeytabPathIOException;
import com.mulesoft.connectors.kafka.internal.error.exception.Krb5ConfFileNotFoundException;
import com.mulesoft.connectors.kafka.internal.error.exception.Krb5ConfPathIOException;
import com.mulesoft.connectors.kafka.internal.error.exception.TicketCacheNotFoundException;
import com.mulesoft.connectors.kafka.internal.error.exception.TicketCachePathIOException;
import com.mulesoft.connectors.kafka.internal.error.exception.UseKeytabNotEnabledException;
import com.mulesoft.connectors.kafka.internal.error.exception.UseTicketCacheNotEnabledException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.StringUtils;

public interface KerberosConnectionProviderUtils {
    public static void setKerberosProperties(Properties properties, KerberosConnectionParams kerberosConnectionParams) throws InitialisationException {
        properties.put("sasl.mechanism", "GSSAPI");
        properties.put("sasl.jaas.config", String.format("com.sun.security.auth.module.Krb5LoginModule required useKeyTab=%s %s useTicketCache=%s %s storeKey=%s principal=\"%s\";", kerberosConnectionParams.isUseKeytab(), Optional.ofNullable(KerberosConnectionProviderUtils.resolvePath(kerberosConnectionParams.getKeytab(), KeytabPathIOException::new)).map(path -> String.format(" keyTab=\"%s\"", path)).orElse(""), kerberosConnectionParams.isUseTicketCache(), Optional.ofNullable(KerberosConnectionProviderUtils.resolvePath(kerberosConnectionParams.getTicketCache(), TicketCachePathIOException::new)).map(path -> String.format(" ticketCache=\"%s\"", path)).orElse(""), kerberosConnectionParams.isStoreKey(), kerberosConnectionParams.getPrincipal()));
        properties.put("sasl.kerberos.service.name", kerberosConnectionParams.getServiceName());
        Optional.ofNullable(KerberosConnectionProviderUtils.resolvePath(kerberosConnectionParams.getKrb5ConfPath(), Krb5ConfPathIOException::new)).ifPresent(path -> System.setProperty("java.security.krb5.conf", path));
        if (!kerberosConnectionParams.isUseKeytab() && !StringUtils.isBlank((String)kerberosConnectionParams.getKeytab())) {
            throw new InitialisationException((Throwable)((Object)new UseKeytabNotEnabledException()), null);
        }
        if (kerberosConnectionParams.isUseKeytab() && StringUtils.isBlank((String)kerberosConnectionParams.getKeytab())) {
            throw new InitialisationException((Throwable)((Object)new EmptyKeytabPathException()), null);
        }
        if (kerberosConnectionParams.isUseKeytab() && !StringUtils.isBlank((String)kerberosConnectionParams.getKeytab()) && Thread.currentThread().getContextClassLoader().getResource(kerberosConnectionParams.getKeytab()) == null && !Paths.get(kerberosConnectionParams.getKeytab(), new String[0]).toFile().exists()) {
            throw new InitialisationException((Throwable)((Object)new KeytabNotFoundException()), null);
        }
        if (!kerberosConnectionParams.isUseTicketCache() && !StringUtils.isBlank((String)kerberosConnectionParams.getTicketCache())) {
            throw new InitialisationException((Throwable)((Object)new UseTicketCacheNotEnabledException()), null);
        }
        if (kerberosConnectionParams.isUseTicketCache() && StringUtils.isBlank((String)kerberosConnectionParams.getTicketCache())) {
            throw new InitialisationException((Throwable)((Object)new EmptyTicketCachePathException()), null);
        }
        if (kerberosConnectionParams.isUseTicketCache() && Thread.currentThread().getContextClassLoader().getResource(kerberosConnectionParams.getTicketCache()) == null && !Paths.get(kerberosConnectionParams.getTicketCache(), new String[0]).toFile().exists()) {
            throw new InitialisationException((Throwable)((Object)new TicketCacheNotFoundException()), null);
        }
        if (StringUtils.isBlank((String)kerberosConnectionParams.getKrb5ConfPath()) || !StringUtils.isBlank((String)kerberosConnectionParams.getKrb5ConfPath()) && Thread.currentThread().getContextClassLoader().getResource(kerberosConnectionParams.getKrb5ConfPath()) == null && !Paths.get(kerberosConnectionParams.getKrb5ConfPath(), new String[0]).toFile().exists()) {
            throw new InitialisationException((Throwable)((Object)new Krb5ConfFileNotFoundException()), null);
        }
    }

    public static String resolvePath(String path, Function<Exception, InvalidConfigurationException> exceptionWrapper) throws InvalidConfigurationException {
        try {
            return StringUtils.isBlank((String)path) ? null : (!Files.exists(Paths.get(path, new String[0]), new LinkOption[0]) ? Optional.ofNullable(FileUtils.getResourcePath((String)path, KerberosConnectionProviderUtils.class)).orElse(path) : path).replace("\\", "/");
        }
        catch (IOException e) {
            throw exceptionWrapper.apply(e);
        }
    }
}

