/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.internal.connection.provider.sasl.kerberos;

import com.mulesoft.connectors.kafka.api.connection.provider.KerberosConnectionParams;
import com.mulesoft.connectors.kafka.internal.connection.ConsumerConnection;
import com.mulesoft.connectors.kafka.internal.connection.provider.sasl.SaslConsumerConnectionProvider;
import com.mulesoft.connectors.kafka.internal.connection.provider.sasl.kerberos.KerberosConnectionProviderUtils;
import com.mulesoft.connectors.kafka.internal.error.exception.KerberosLoginException;
import java.util.Properties;
import javax.security.auth.login.LoginException;
import org.apache.kafka.common.KafkaException;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;

@Alias(value="consumer-sasl-gssapi-connection")
@DisplayName(value="Consumer Kerberos Connection")
public class KerberosConsumerConnectionProvider
extends SaslConsumerConnectionProvider
implements CachedConnectionProvider<ConsumerConnection> {
    @ParameterGroup(name="SASL/GSSAPI")
    private KerberosConnectionParams kerberosConnectionParams;

    @Override
    protected void handleConnectionException(KafkaException kafkaException) {
        if (kafkaException.getCause() instanceof LoginException) {
            throw new KerberosLoginException(kafkaException.getMessage(), kafkaException);
        }
        super.handleConnectionException(kafkaException);
    }

    @Override
    protected void initialise(Properties properties) throws InitialisationException {
        super.initialise(properties);
        KerberosConnectionProviderUtils.setKerberosProperties(properties, this.kerberosConnectionParams);
    }
}

