/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.internal.model.consumer;

import java.io.Closeable;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;

public class Session<F>
implements Closeable {
    private final UUID id = UUID.randomUUID();
    private final Consumer<F> checkInOperation;
    private F sessionElement;

    public Session(F sessionElement, Consumer<F> checkInOperation) {
        this.sessionElement = sessionElement;
        this.checkInOperation = checkInOperation;
    }

    public void run(Consumer<F> consumer) {
        consumer.accept(this.sessionElement);
    }

    public <T> T apply(Function<F, T> function) {
        return function.apply(this.sessionElement);
    }

    public UUID getId() {
        return this.id;
    }

    @Override
    public void close() {
        this.checkInOperation.accept(this.sessionElement);
    }
}

