/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.internal.operation;

import com.mulesoft.connectors.kafka.api.operation.KafkaMessageMetadata;
import com.mulesoft.connectors.kafka.internal.config.ProducerConfiguration;
import com.mulesoft.connectors.kafka.internal.connection.ProducerConnection;
import com.mulesoft.connectors.kafka.internal.error.provider.PublishErrorTypeProvider;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Throws(value={PublishErrorTypeProvider.class})
public class PublishOperation {
    private static final Logger logger = LoggerFactory.getLogger(PublishOperation.class);

    public void publish(@Config ProducerConfiguration config, @Connection ProducerConnection connection, @ConfigOverride String topic, @Optional Integer partition, @Optional InputStream key, @Content(primary=true) InputStream message, @Content @Optional @NullSafe Map<String, InputStream> headers, CompletionCallback<KafkaMessageMetadata, Void> completionCallback) {
        String partns = Objects.isNull(partition) ? "any partition" : "partition ";
        logger.debug("Publishing message to topic {} and {}.", (Object)topic, (Object)partns);
        connection.publish(topic, partition, key, message, headers, recordMetadata -> completionCallback.success(config.parseMetadata((RecordMetadata)recordMetadata)), arg_0 -> completionCallback.error(arg_0));
    }
}

