/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.kafka.internal.operation;

import com.mulesoft.connectors.kafka.internal.config.ConsumerConfiguration;
import com.mulesoft.connectors.kafka.internal.connection.ConsumerConnection;
import com.mulesoft.connectors.kafka.internal.error.provider.SeekErrorTypeProvider;
import java.util.concurrent.TimeUnit;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.ConfigOverride;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.display.DisplayName;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Throws(value={SeekErrorTypeProvider.class})
public class SeekOperation {
    private static final Logger logger = LoggerFactory.getLogger(SeekOperation.class);

    @Summary(value="Sets the current offset value for the given topic, partition and consumer group of the listener.")
    public void seek(@Config ConsumerConfiguration config, @Connection ConsumerConnection connection, @DisplayName(value="Topic") @Summary(value="The topic name") @Placement(order=1) String topic, @DisplayName(value="Partition") @Summary(value="The name of the partition") @Placement(order=2) int partition, @DisplayName(value="Offset") @Summary(value="The offset to seek to") @Placement(order=3) long offset, @Optional @ConfigOverride @Placement(tab="Advanced", order=1) long operationTimeout, @Optional @ConfigOverride @Placement(tab="Advanced", order=2) TimeUnit operationTimeoutTimeUnit) throws ConnectionException {
        logger.debug("Seeking on topic {} and partition {} for offset {}.", new Object[]{topic, partition, offset});
        connection.seek(topic, partition, offset, config.asDuration(operationTimeout, operationTimeoutTimeUnit));
    }
}

