/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.client;

import com.mulesoft.connectors.mcp.internal.ConfigTracker;
import com.mulesoft.connectors.mcp.internal.client.connection.provider.sse.SseClientConnectionProvider;
import com.mulesoft.connectors.mcp.internal.client.connection.provider.streamable.StreamableHttpClientConnectionProvider;
import com.mulesoft.connectors.mcp.internal.client.operation.ClientProtocolOperations;
import com.mulesoft.connectors.mcp.internal.client.operation.resource.ClientResourceOperations;
import com.mulesoft.connectors.mcp.internal.client.operation.tool.ClientToolOperations;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.sdk.api.annotation.Configuration;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.annotation.Operations;
import org.mule.sdk.api.annotation.connectivity.ConnectionProviders;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.RefName;
import org.mule.sdk.api.annotation.param.display.Example;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.sdk.api.meta.ExpressionSupport;

@Configuration(name="client")
@ConnectionProviders(value={StreamableHttpClientConnectionProvider.class, SseClientConnectionProvider.class})
@Operations(value={ClientToolOperations.class, ClientResourceOperations.class, ClientProtocolOperations.class})
public class ClientConfig
implements Initialisable,
Disposable {
    @Inject
    private ConfigTracker configTracker;
    @RefName
    private String refName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Example(value="Mule MCP connector")
    @Summary(value="The name that this client will use to identify itself during the protocol initialization phase.")
    private String clientName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Example(value="1.0.0")
    @Summary(value="The version that this client will use to identify itself during the protocol initialization phase")
    private String clientVersion;

    public void initialise() throws InitialisationException {
        this.configTracker.register(this);
    }

    public void dispose() {
        this.configTracker.unregister(this);
    }

    public String getClientName() {
        return this.clientName;
    }

    public String getClientVersion() {
        return this.clientVersion;
    }

    public String getRefName() {
        return this.refName;
    }
}

