/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.source.resource;

import com.mulesoft.connectors.mcp.api.server.RequestAttributes;
import com.mulesoft.connectors.mcp.api.server.resource.Resource;
import com.mulesoft.connectors.mcp.api.server.resource.ResourceRequest;
import com.mulesoft.connectors.mcp.internal.McpUtils;
import com.mulesoft.connectors.mcp.internal.design.vp.MimeTypeValueProvider;
import com.mulesoft.connectors.mcp.internal.server.source.AbstractRequestListener;
import com.mulesoft.connectors.mcp.internal.server.source.resource.ResourceContentTransformer;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import java.util.function.BiFunction;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.annotation.dsl.xml.ParameterDsl;
import org.mule.sdk.api.annotation.execution.OnError;
import org.mule.sdk.api.annotation.execution.OnSuccess;
import org.mule.sdk.api.annotation.execution.OnTerminate;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.RefName;
import org.mule.sdk.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.param.display.Text;
import org.mule.sdk.api.annotation.source.EmitsResponse;
import org.mule.sdk.api.annotation.values.OfValues;
import org.mule.sdk.api.meta.ExpressionSupport;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.mule.sdk.api.runtime.source.SourceResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

@DisplayName(value="MCP Server - Resource listener")
@EmitsResponse
public class ResourceListener
extends AbstractRequestListener<ResourceRequest, RequestAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceListener.class);
    private static final String REQUEST_CTX_VAR = "_request";
    @Parameter
    @Summary(value="The resource name")
    private String name;
    @Parameter
    @Text
    @Summary(value="A detailed enough description for an LLM to determine when this resource should be read")
    private String description;
    @Parameter
    @Summary(value="The resource URI")
    private String uri;
    @Parameter
    @OfValues(value=MimeTypeValueProvider.class)
    @Summary(value="The resource mime type")
    private String resourceMimeType;
    @RefName
    private String configName;
    private ComponentLocation location;

    @Override
    protected void doStart(SourceCallback<ResourceRequest, RequestAttributes> sourceCallback) throws MuleException {
        McpUtils.parseAndValidate(this.uri);
        try {
            this.getServer().addResource(new McpServerFeatures.AsyncResourceSpecification(new McpSchema.Resource(this.uri, this.name, this.description, this.resourceMimeType, null), this.requestHandler(sourceCallback))).block();
        }
        catch (Exception e) {
            throw new DefaultMuleException("Error registering resource '%s' for config '%s'".formatted(this.uri, this.configName), (Throwable)e);
        }
    }

    private BiFunction<McpAsyncServerExchange, McpSchema.ReadResourceRequest, Mono<McpSchema.ReadResourceResult>> requestHandler(SourceCallback<ResourceRequest, RequestAttributes> sourceCallback) {
        return (exchg, request) -> Mono.create(sink -> {
            SourceCallbackContext ctx = sourceCallback.createContext();
            this.setInContext(sink, ctx);
            ctx.addVariable(REQUEST_CTX_VAR, request);
            try {
                sourceCallback.handle(Result.builder().output((Object)new ResourceRequest(request.uri())).mediaType(MediaType.APPLICATION_JAVA).attributes((Object)McpUtils.getRequestAttributes(this.messagingManager)).build(), ctx);
            }
            catch (Exception e) {
                LOGGER.error("Failed to route resources/read request due to exception", (Throwable)e);
                sink.error((Throwable)e);
            }
        });
    }

    @OnSuccess
    public void onSuccess(@Expression(value=ExpressionSupport.NOT_SUPPORTED) @ParameterDsl(allowReferences=false) Resource resourceListenerContent, SourceCallbackContext context) {
        MonoSink sink = this.getSink(context);
        try {
            sink.success((Object)this.toMcpResult(resourceListenerContent, context));
        }
        catch (Exception e) {
            LOGGER.error("Exception found sending resource response", (Throwable)e);
            sink.error((Throwable)e);
        }
    }

    @OnError
    public void onError(Error error, SourceCallbackContext context) {
        this.getSink(context).error(error.getCause());
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) {
        sourceResult.getResponseError().ifPresent(error -> LOGGER.error("<mcp:resource-listener> listener at location {} failed to send response to client: {}", new Object[]{this.location.getLocation(), error.getDescription(), error.getCause()}));
    }

    private McpSchema.ReadResourceResult toMcpResult(Resource resourceContent, SourceCallbackContext context) {
        McpSchema.ReadResourceRequest request = (McpSchema.ReadResourceRequest)context.getVariable(REQUEST_CTX_VAR).get();
        ResourceContentTransformer transformer = new ResourceContentTransformer(request.uri(), this.resourceMimeType);
        resourceContent.accept(transformer);
        return new McpSchema.ReadResourceResult(List.of(transformer.getContent()));
    }

    @Override
    protected void doStop() {
    }
}

