/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.source.tool;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.mcp.api.server.RequestAttributes;
import com.mulesoft.connectors.mcp.api.server.tool.ToolResponseContent;
import com.mulesoft.connectors.mcp.internal.McpUtils;
import com.mulesoft.connectors.mcp.internal.jackson.ObjectMapperFactory;
import com.mulesoft.connectors.mcp.internal.server.source.AbstractRequestListener;
import com.mulesoft.connectors.mcp.internal.server.source.tool.ServerToolResultContentTransformer;
import com.mulesoft.connectors.mcp.internal.server.source.tool.datasense.ToolListenerOutputResolver;
import io.modelcontextprotocol.server.McpAsyncServerExchange;
import io.modelcontextprotocol.server.McpServerFeatures;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.exception.DefaultMuleException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.http.api.server.RequestHandlerManager;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.annotation.dsl.xml.ParameterDsl;
import org.mule.sdk.api.annotation.execution.OnError;
import org.mule.sdk.api.annotation.execution.OnSuccess;
import org.mule.sdk.api.annotation.execution.OnTerminate;
import org.mule.sdk.api.annotation.metadata.MetadataKeyId;
import org.mule.sdk.api.annotation.metadata.MetadataScope;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.sdk.api.annotation.param.display.Text;
import org.mule.sdk.api.annotation.source.EmitsResponse;
import org.mule.sdk.api.meta.ExpressionSupport;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.mule.sdk.api.runtime.source.SourceResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

@DisplayName(value="MCP Server - Tool Listener")
@EmitsResponse
@MetadataScope(outputResolver=ToolListenerOutputResolver.class)
public class ToolListener
extends AbstractRequestListener<Map<String, Object>, RequestAttributes> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ToolListener.class);
    @Parameter
    @Summary(value="The tool's name")
    private String name;
    @Parameter
    @Text
    @Summary(value="A detailed enough description for an LLM to determine when this tool should be called")
    private String description;
    @Parameter
    @MetadataKeyId
    @Text
    @Summary(value="A JSON schema defining an object which fields will act as the tool's input arguments")
    private String parametersSchema;
    private RequestHandlerManager restAdapterHandlerManager;
    private ObjectMapper objectMapper = ObjectMapperFactory.get();
    private ComponentLocation location;

    @Override
    protected void doStart(SourceCallback<Map<String, Object>, RequestAttributes> sourceCallback) throws MuleException {
        try {
            this.getServer().addTool(new McpServerFeatures.AsyncToolSpecification(new McpSchema.Tool(this.name, this.description, this.parametersSchema), this.requestHandler(sourceCallback))).block();
        }
        catch (Exception e) {
            throw new DefaultMuleException("Error registering tool '%s' for config '%s'".formatted(this.name, this.serverConfig.getRefName()), (Throwable)e);
        }
    }

    private BiFunction<McpAsyncServerExchange, Map<String, Object>, Mono<McpSchema.CallToolResult>> requestHandler(SourceCallback<Map<String, Object>, RequestAttributes> sourceCallback) {
        return (exch, args) -> Mono.create(sink -> {
            SourceCallbackContext ctx = sourceCallback.createContext();
            this.setInContext(sink, ctx);
            try {
                sourceCallback.handle(Result.builder().output(Collections.unmodifiableMap(args)).mediaType(MediaType.APPLICATION_JAVA).attributes((Object)McpUtils.getRequestAttributes(this.messagingManager)).build(), ctx);
            }
            catch (Exception e) {
                LOGGER.error("Failed to route tools/call request due to exception", (Throwable)e);
                sink.error((Throwable)e);
            }
        });
    }

    @OnSuccess
    public void onSuccess(@Expression(value=ExpressionSupport.NOT_SUPPORTED) @ParameterDsl(allowReferences=false) List<ToolResponseContent> responses, SourceCallbackContext context) {
        MonoSink sink = this.getSink(context);
        try {
            McpSchema.CallToolResult mcpResponse = new McpSchema.CallToolResult(this.getContentsFrom(responses, null), Boolean.valueOf(false));
            sink.success((Object)mcpResponse);
        }
        catch (Exception e) {
            LOGGER.error("Exception found creating success tool response", (Throwable)e);
            sink.error((Throwable)e);
        }
    }

    @OnError
    public void onError(@Expression(value=ExpressionSupport.NOT_SUPPORTED) @ParameterDsl(allowReferences=false) @Optional List<ToolResponseContent> onErrorResponses, Error error, SourceCallbackContext context) {
        MonoSink sink = this.getSink(context);
        try {
            McpSchema.CallToolResult mcpResponse = new McpSchema.CallToolResult(this.getContentsFrom(onErrorResponses, error), Boolean.valueOf(true));
            sink.success((Object)mcpResponse);
        }
        catch (Exception e) {
            LOGGER.error("Exception found creating error tool response", (Throwable)e);
            sink.error((Throwable)e);
        }
    }

    @OnTerminate
    public void onTerminate(SourceResult sourceResult) {
        sourceResult.getResponseError().ifPresent(error -> LOGGER.error("<mcp:tool-listener> at location {} failed to send response to client: {}", new Object[]{this.location.getLocation(), error.getDescription(), error.getCause()}));
    }

    private List<McpSchema.Content> getContentsFrom(List<ToolResponseContent> responses, Error error) {
        if (error != null && (responses == null || responses.isEmpty())) {
            return List.of(new McpSchema.TextContent(error.getDescription()));
        }
        ServerToolResultContentTransformer resultTransformer = new ServerToolResultContentTransformer();
        responses.forEach(i -> i.accept(resultTransformer));
        return resultTransformer.getContents();
    }

    @Override
    protected void doStop() {
        this.getServer().removeTool(this.name);
        if (this.restAdapterHandlerManager != null) {
            this.restAdapterHandlerManager.stop();
            this.restAdapterHandlerManager.dispose();
            this.restAdapterHandlerManager = null;
        }
    }
}

