/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.api.certificate;

import java.io.Serializable;

public class CertificateExtension
implements Serializable {
    private String oid;
    private byte[] value;
    private boolean criticality;
    private String subjectAlternativeName;

    public CertificateExtension(String oid, boolean criticality, byte[] value, String subjectAlternativeName) {
        this.oid = oid;
        this.criticality = criticality;
        this.value = value;
        this.subjectAlternativeName = subjectAlternativeName;
    }

    public String getOid() {
        return this.oid;
    }

    public byte[] getValue() {
        return this.value;
    }

    public boolean getCriticality() {
        return this.criticality;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ObjectId: ").append(this.getOid()).append(" Criticality=").append(this.getCriticality()).append("\n");
        switch (this.oid) {
            case "2.5.29.17": {
                sb.append("SubjectAlternativeName [\n");
                sb.append(this.subjectAlternativeName);
                sb.append("]\n");
                break;
            }
            case "2.5.29.14": {
                sb.append("SubjectKeyIdentifier [\n");
                sb.append(this.parseSubjectKeyIdentifier(this.value));
                sb.append("]\n");
                sb.append("\n]");
                break;
            }
            default: {
                sb.append("Unknown Extension Type\n");
            }
        }
        return sb.toString();
    }

    private String parseSubjectKeyIdentifier(byte[] value) {
        StringBuilder sb = new StringBuilder();
        sb.append("KeyIdentifier [\n");
        sb.append(CertificateExtension.formatHexAndAscii(value));
        sb.append("]\n");
        return sb.toString();
    }

    public static String formatHexAndAscii(byte[] value) {
        StringBuilder sb = new StringBuilder();
        int lineLength = 16;
        for (int i = 0; i < value.length; i += lineLength) {
            int j;
            sb.append(String.format("%04X: ", i));
            for (j = 0; j < lineLength; ++j) {
                if (i + j < value.length) {
                    sb.append(String.format("%02X ", value[i + j]));
                } else {
                    sb.append("   ");
                }
                if (j != 7) continue;
                sb.append("  ");
            }
            sb.append(" ");
            for (j = 0; j < lineLength && i + j < value.length; ++j) {
                byte b = value[i + j];
                if (b >= 32 && b <= 126) {
                    sb.append((char)b);
                    continue;
                }
                sb.append('.');
            }
            sb.append("\n");
        }
        return sb.toString();
    }
}

