/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal;

import com.mulesoft.connectors.mcp.api.Role;
import com.mulesoft.connectors.mcp.api.server.RequestAttributes;
import com.mulesoft.connectors.mcp.internal.MessagingManager;
import com.mulesoft.connectors.mcp.internal.error.McpErrorTypes;
import io.modelcontextprotocol.spec.McpSchema;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Base64;
import java.util.List;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.sdk.api.error.ErrorTypeDefinition;
import org.mule.sdk.api.exception.ModuleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class McpUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(McpUtils.class);

    private McpUtils() {
    }

    public static URI parseAndValidate(String uri) {
        try {
            return new URI(uri);
        }
        catch (URISyntaxException e) {
            throw new ModuleException("'%s' is not a valid URI".formatted(uri), (ErrorTypeDefinition)McpErrorTypes.INVALID_URI, (Throwable)e);
        }
    }

    public static List<McpSchema.Role> toMcpRoles(List<Role> roles) {
        if (roles == null || roles.isEmpty()) {
            return List.of();
        }
        return roles.stream().map(r -> McpSchema.Role.valueOf((String)r.name())).toList();
    }

    public static List<Role> fromMcpRoles(List<McpSchema.Role> roles) {
        if (roles == null || roles.isEmpty()) {
            return List.of();
        }
        return roles.stream().map(r -> Role.valueOf(r.name())).toList();
    }

    public static String toBase64(InputStream inputStream) {
        return new String(Base64.getEncoder().encode(IOUtils.toByteArray((InputStream)inputStream)));
    }

    public static byte[] fromBase64(String base64) {
        return Base64.getDecoder().decode(base64);
    }

    public static RequestAttributes getRequestAttributes(MessagingManager tracker) {
        return tracker.popInbound().map(request -> new RequestAttributes(request.getSessionId(), ((McpSchema.JSONRPCRequest)request.getMessage()).id().toString(), request.getAdditionalProperties(), request.getClientCertificate())).orElseGet(RequestAttributes::new);
    }

    public static McpSchema.JSONRPCResponse rpcErrorResponse(McpSchema.JSONRPCMessage originalMessage, McpErrorTypes errorType, String message) {
        Object id = originalMessage instanceof McpSchema.JSONRPCRequest ? ((McpSchema.JSONRPCRequest)originalMessage).id() : null;
        return McpUtils.rpcErrorResponse(id, errorType, message);
    }

    public static McpSchema.JSONRPCResponse rpcErrorResponse(Object id, McpErrorTypes errorType, String message) {
        return new McpSchema.JSONRPCResponse("2.0", id, null, new McpSchema.JSONRPCResponse.JSONRPCError(errorType.getCode().orElse(McpErrorTypes.SERVER_ERROR.getCode().get()).intValue(), message, null));
    }

    public static <K, V> MultiMap<K, V> immutable(MultiMap<K, V> multiMap) {
        return multiMap != null ? multiMap.toImmutableMultiMap() : MultiMap.emptyMultiMap();
    }
}

