/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.client.connection.transport;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.mcp.internal.MessagingManager;
import com.mulesoft.connectors.mcp.internal.jackson.ObjectMapperFactory;
import io.modelcontextprotocol.spec.McpClientTransport;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.HttpRequestOptionsBuilder;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;

public abstract class AbstractHttpClientTransport
implements McpClientTransport {
    protected final String serverUrl;
    protected final HttpRequestAuthentication authentication;
    protected final HttpRequestOptions requestOptions;
    protected final MessagingManager messagingManager;
    protected final AtomicBoolean opened = new AtomicBoolean(false);
    protected final ObjectMapper objectMapper = ObjectMapperFactory.get();
    protected final HttpClient httpClient;

    public AbstractHttpClientTransport(HttpClient httpClient, String serverUrl, int responseTimeout, HttpRequestAuthentication authentication, MessagingManager messagingManager) {
        this.httpClient = httpClient;
        this.serverUrl = serverUrl;
        this.messagingManager = messagingManager;
        HttpRequestOptionsBuilder optionsBuilder = HttpRequestOptions.builder().responseTimeout(responseTimeout);
        if (authentication instanceof HttpAuthentication) {
            HttpAuthentication auth = (HttpAuthentication)authentication;
            optionsBuilder.authentication(auth);
            this.authentication = null;
        } else {
            this.authentication = authentication;
        }
        this.requestOptions = optionsBuilder.build();
    }

    public <T> T unmarshalFrom(Object data, TypeReference<T> typeRef) {
        return (T)this.objectMapper.convertValue(data, typeRef);
    }
}

