/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.client.operation.tool.datasense;

import com.mulesoft.connectors.mcp.internal.design.datasense.DataSenseUtils;
import com.mulesoft.connectors.mcp.internal.jackson.ObjectMapperFactory;
import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.json.api.JsonTypeLoader;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.FailureCode;
import org.mule.sdk.api.metadata.MetadataContext;
import org.mule.sdk.api.metadata.resolving.InputTypeResolver;

public class ClientToolInputTypeResolver
implements InputTypeResolver<String> {
    public MetadataType getInputMetadata(MetadataContext metadataContext, String toolName) throws MetadataResolvingException, ConnectionException {
        McpAsyncClient client = (McpAsyncClient)metadataContext.getConnection().get();
        McpSchema.Tool tool = this.findTool(client, toolName).orElseThrow(() -> new MetadataResolvingException("Could not find tool '%s'".formatted(toolName), FailureCode.RESOURCE_UNAVAILABLE));
        try {
            String jsonSchema = ObjectMapperFactory.get().writeValueAsString((Object)tool.inputSchema());
            ObjectType schemaType = (ObjectType)new JsonTypeLoader(jsonSchema).load(null).get();
            return DataSenseUtils.copyFieldsOnNewJavaObject(schemaType, metadataContext.getTypeBuilder());
        }
        catch (Exception e) {
            throw new MetadataResolvingException(e.getMessage(), FailureCode.UNKNOWN, (Throwable)e);
        }
    }

    public String getCategoryName() {
        return "ds.category.calltool.operation";
    }

    public String getResolverName() {
        return this.getClass().getName();
    }

    private Optional<McpSchema.Tool> findTool(McpAsyncClient client, String toolName) throws MetadataResolvingException {
        McpSchema.ListToolsResult response;
        String cursor = null;
        do {
            Optional<McpSchema.Tool> tool;
            if (!(tool = (response = DataSenseUtils.queryTools(client, cursor)).tools().stream().filter(t -> t.name().equals(toolName)).findFirst()).isPresent()) continue;
            return tool;
        } while ((cursor = response.nextCursor()) != null);
        return Optional.empty();
    }
}

