/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.error;

import java.util.Optional;
import java.util.stream.Stream;
import org.mule.sdk.api.error.ErrorTypeDefinition;

public enum McpErrorTypes implements ErrorTypeDefinition<McpErrorTypes>
{
    JSON_RPC_ERROR,
    PARSE_ERROR(JSON_RPC_ERROR, -32700),
    INVALID_REQUEST(JSON_RPC_ERROR, -32600),
    METHOD_NOT_FOUND(JSON_RPC_ERROR, -32601),
    INVALID_PARAMS(JSON_RPC_ERROR, -32602),
    INTERNAL_ERROR(JSON_RPC_ERROR, -32603),
    SERVER_ERROR(JSON_RPC_ERROR, -32000),
    REQUEST_TIMEOUT,
    INVALID_URI;

    private final McpErrorTypes parent;
    private final Integer code;

    public static McpErrorTypes fromRpcErrorCode(int errorCode) {
        return Stream.of(McpErrorTypes.values()).filter(type -> type.getCode().orElse(0) == errorCode).findFirst().orElse(SERVER_ERROR);
    }

    private McpErrorTypes() {
        this(null, null);
    }

    private McpErrorTypes(McpErrorTypes parent, Integer code) {
        this.parent = parent;
        this.code = code;
    }

    public Optional<ErrorTypeDefinition<? extends Enum<?>>> getParent() {
        return Optional.ofNullable(this.parent);
    }

    public Optional<Integer> getCode() {
        return Optional.ofNullable(this.code);
    }

    public boolean isJsonRpcError() {
        if (this == JSON_RPC_ERROR) {
            return true;
        }
        if (this.parent != null) {
            return this.parent.isJsonRpcError();
        }
        return false;
    }
}

