/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.config;

import com.mulesoft.connectors.mcp.internal.ConfigTracker;
import com.mulesoft.connectors.mcp.internal.server.connection.provider.BaseServerTransportProvider;
import com.mulesoft.connectors.mcp.internal.server.connection.provider.sse.SSEServerConnectionProvider;
import com.mulesoft.connectors.mcp.internal.server.connection.provider.streamable.StreamableHttpServerConnectionProvider;
import com.mulesoft.connectors.mcp.internal.server.source.resource.ResourceListener;
import com.mulesoft.connectors.mcp.internal.server.source.session.OnNewSessionListener;
import com.mulesoft.connectors.mcp.internal.server.source.tool.ToolListener;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.annotation.connectivity.ConnectionProviders;
import org.mule.sdk.api.annotation.Configuration;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.annotation.Sources;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.RefName;
import org.mule.sdk.api.annotation.param.display.Example;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.sdk.api.meta.ExpressionSupport;

@Configuration(name="server")
@ConnectionProviders(value={StreamableHttpServerConnectionProvider.class, SSEServerConnectionProvider.class})
@Sources(value={ToolListener.class, ResourceListener.class, OnNewSessionListener.class})
public class ServerConfig
implements Initialisable,
Disposable {
    @Inject
    private ConfigTracker configTracker;
    @RefName
    private String refName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Example(value="mule-mcp-server")
    @Summary(value="The name that this server will use to identify itself during the protocol initialization phase")
    private String serverName;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Example(value="1.0.0")
    @Summary(value="The version that this client will use to identify itself during the protocol initialization phase")
    private String serverVersion;
    private BaseServerTransportProvider transport;

    public void initialise() throws InitialisationException {
        this.configTracker.register(this);
    }

    public void dispose() {
        this.configTracker.unregister(this);
    }

    public String getRefName() {
        return this.refName;
    }

    public BaseServerTransportProvider getTransport() {
        return this.transport;
    }

    public void setTransport(BaseServerTransportProvider transport) {
        this.transport = transport;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerVersion() {
        return this.serverVersion;
    }
}

