/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.session;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import com.mulesoft.connectors.mcp.internal.server.connection.MuleServerSession;
import com.mulesoft.connectors.mcp.internal.server.session.SessionManager;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.core.api.util.func.CheckedSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedL2SessionManager
implements SessionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedL2SessionManager.class);
    private final String ownerConfigName;
    private final Cache<String, MuleServerSession> l1Cache;
    private final ObjectStore<MuleServerSession> l2ObjectStore;
    private final LockFactory lockFactory;

    public DistributedL2SessionManager(String ownerConfigName, ObjectStore<MuleServerSession> l2ObjectStore, LockFactory lockFactory, Long sessionTimeoutMillis) {
        this.ownerConfigName = ownerConfigName;
        this.l2ObjectStore = l2ObjectStore;
        this.lockFactory = lockFactory;
        this.l1Cache = Caffeine.newBuilder().expireAfterAccess(sessionTimeoutMillis.longValue(), TimeUnit.MILLISECONDS).removalListener((key, value, cause) -> {
            if (cause == RemovalCause.EXPIRED) {
                LOGGER.debug("Server Session {} expired for L1 cache. Closing.", key);
                this.close((MuleServerSession)value);
            }
        }).build();
    }

    @Override
    public Optional<MuleServerSession> recoverSession(String sessionId) {
        return Optional.ofNullable((MuleServerSession)this.l1Cache.get((Object)sessionId, id -> (MuleServerSession)this.withLock((String)id, () -> {
            if (this.l2ObjectStore.contains(id)) {
                return (MuleServerSession)this.l2ObjectStore.retrieve(id);
            }
            return null;
        })));
    }

    @Override
    public void upsert(MuleServerSession session) {
        String sessionId = session.getId();
        this.withLock(sessionId, () -> {
            if (this.l2ObjectStore.contains(sessionId)) {
                this.l2ObjectStore.remove(sessionId);
            }
            this.l2ObjectStore.store(sessionId, (Serializable)session);
            this.l1Cache.put((Object)sessionId, (Object)session);
            return null;
        });
    }

    @Override
    public boolean unregisterAndClose(String sessionId) {
        return (Boolean)this.withLock(sessionId, () -> {
            boolean found = false;
            MuleServerSession session = (MuleServerSession)this.l1Cache.asMap().get(sessionId);
            if (session != null) {
                found = true;
                this.close(session);
                this.l1Cache.invalidate((Object)sessionId);
            }
            if (this.l2ObjectStore.contains(sessionId)) {
                found = this.l2ObjectStore.remove(sessionId) != null || found;
            }
            return found;
        });
    }

    private void close(MuleServerSession session) {
        try {
            session.close();
            LOGGER.debug("Server Session {} closed.", (Object)session.getId());
        }
        catch (Exception e) {
            LOGGER.error("Error closing session with id: {}", (Object)session.getId(), (Object)e);
        }
    }

    public List<MuleServerSession> getLocalSessions() {
        return List.copyOf(this.l1Cache.asMap().values());
    }

    @Override
    public void close() {
        try {
            this.l2ObjectStore.close();
        }
        catch (Exception e) {
            LOGGER.error("Error closing objectStore for session manager of config {}", (Object)this.ownerConfigName, (Object)e);
        }
        this.l1Cache.invalidateAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T withLock(String sessionId, CheckedSupplier<T> supplier) {
        Lock lock = this.lockFactory.createLock(this.getLockKey(sessionId));
        lock.lock();
        try {
            Object object = supplier.get();
            return (T)object;
        }
        finally {
            lock.unlock();
        }
    }

    private String getLockKey(String sessionId) {
        return "mcp-server-sessions-" + this.ownerConfigName + "-" + sessionId;
    }
}

