/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.source.tool;

import com.mulesoft.connectors.mcp.api.server.tool.BlobResourceToolResponseContent;
import com.mulesoft.connectors.mcp.api.server.tool.ImageToolResponseContent;
import com.mulesoft.connectors.mcp.api.server.tool.ServerToolContentVisitor;
import com.mulesoft.connectors.mcp.api.server.tool.TextResourceToolResponseContent;
import com.mulesoft.connectors.mcp.api.server.tool.TextToolResponseContent;
import com.mulesoft.connectors.mcp.internal.McpUtils;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.ArrayList;
import java.util.List;

public class ServerToolResultContentTransformer
implements ServerToolContentVisitor {
    private List<McpSchema.Content> contents = new ArrayList<McpSchema.Content>();

    @Override
    public void visit(TextToolResponseContent response) {
        this.contents.add((McpSchema.Content)new McpSchema.TextContent(McpUtils.toMcpRoles(response.getAudience()), response.getPriority(), response.getText()));
    }

    @Override
    public void visit(ImageToolResponseContent response) {
        this.contents.add((McpSchema.Content)new McpSchema.ImageContent(McpUtils.toMcpRoles(response.getAudience()), response.getPriority(), McpUtils.toBase64(response.getData()), response.getMimeType()));
    }

    @Override
    public void visit(TextResourceToolResponseContent response) {
        this.contents.add((McpSchema.Content)new McpSchema.EmbeddedResource(McpUtils.toMcpRoles(response.getAudience()), response.getPriority(), (McpSchema.ResourceContents)new McpSchema.TextResourceContents(response.getUri(), response.getMimeType(), response.getText())));
    }

    @Override
    public void visit(BlobResourceToolResponseContent response) {
        this.contents.add((McpSchema.Content)new McpSchema.EmbeddedResource(McpUtils.toMcpRoles(response.getAudience()), response.getPriority(), (McpSchema.ResourceContents)new McpSchema.BlobResourceContents(response.getUri(), response.getMimeType(), McpUtils.toBase64(response.getBlob()))));
    }

    public List<McpSchema.Content> getContents() {
        return this.contents;
    }
}

