/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.util;

import com.mulesoft.connectors.mcp.api.certificate.AlternativeNameData;
import com.mulesoft.connectors.mcp.api.certificate.CertificateData;
import com.mulesoft.connectors.mcp.api.certificate.CertificateExtension;
import com.mulesoft.connectors.mcp.api.certificate.PrincipalData;
import com.mulesoft.connectors.mcp.api.certificate.PublicKeyData;
import java.math.BigInteger;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.http.api.domain.request.ClientConnection;

public final class CertificateUtils {
    public static CertificateData buildCertificateData(ClientConnection clientConnection) {
        byte[] encoded;
        Certificate certificate = clientConnection.getClientCertificate();
        if (certificate == null) {
            return null;
        }
        if (!(certificate instanceof X509Certificate)) {
            throw new IllegalArgumentException("Only X509Certificates are supported.");
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        String type = x509Certificate.getType();
        try {
            encoded = x509Certificate.getEncoded();
        }
        catch (CertificateEncodingException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
        int version = x509Certificate.getVersion();
        PrincipalData subjectDN = new PrincipalData(x509Certificate.getSubjectDN().getName());
        PrincipalData issuerDN = new PrincipalData(x509Certificate.getIssuerDN().getName());
        BigInteger serialNumber = x509Certificate.getSerialNumber();
        Date notBefore = x509Certificate.getNotBefore();
        Date notAfter = x509Certificate.getNotAfter();
        RSAPublicKey publicKey = (RSAPublicKey)certificate.getPublicKey();
        BigInteger modulus = publicKey.getModulus();
        BigInteger publicExponent = publicKey.getPublicExponent();
        PublicKeyData publicKeyData = new PublicKeyData(publicKey.toString(), modulus, publicExponent, publicKey.getAlgorithm(), publicKey.getEncoded());
        String sigAlgName = x509Certificate.getSigAlgName();
        String sigAlgOID = x509Certificate.getSigAlgOID();
        byte[] sigAlgParams = x509Certificate.getSigAlgParams();
        byte[] signature = x509Certificate.getSignature();
        int basicConstraints = x509Certificate.getBasicConstraints();
        List<String> extendedKeyUsage = Collections.emptyList();
        try {
            extendedKeyUsage = x509Certificate.getExtendedKeyUsage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean[] keyUsage = x509Certificate.getKeyUsage();
        boolean[] issuerUniqueID = x509Certificate.getIssuerUniqueID();
        List<AlternativeNameData> subjectAlternativeNames = Collections.emptyList();
        try {
            Collection<List<?>> sans = x509Certificate.getSubjectAlternativeNames();
            if (sans != null) {
                subjectAlternativeNames = sans.stream().map(san -> new AlternativeNameData(((Number)san.get(0)).intValue(), san.get(1).toString())).collect(Collectors.toList());
            }
        }
        catch (Exception sans) {
            // empty catch block
        }
        List<AlternativeNameData> issuerAlternativeNames = Collections.emptyList();
        try {
            Collection<List<?>> ians = x509Certificate.getIssuerAlternativeNames();
            if (ians != null) {
                issuerAlternativeNames = ians.stream().map(ian -> new AlternativeNameData(((Number)ian.get(0)).intValue(), ian.get(1).toString())).collect(Collectors.toList());
            }
        }
        catch (Exception ians) {
            // empty catch block
        }
        ArrayList<CertificateExtension> extensions = new ArrayList<CertificateExtension>();
        for (String oid : x509Certificate.getNonCriticalExtensionOIDs()) {
            extensions.add(new CertificateExtension(oid, false, CertificateUtils.decodeExtensionValue(x509Certificate.getExtensionValue(oid)), CertificateUtils.parseSubjectAlternativeName(x509Certificate)));
        }
        for (String oid : x509Certificate.getCriticalExtensionOIDs()) {
            extensions.add(new CertificateExtension(oid, true, CertificateUtils.decodeExtensionValue(x509Certificate.getExtensionValue(oid)), CertificateUtils.parseSubjectAlternativeName(x509Certificate)));
        }
        Collections.reverse(extensions);
        Set<String> criticalOids = x509Certificate.getCriticalExtensionOIDs();
        Set<String> nonCriticalOids = x509Certificate.getNonCriticalExtensionOIDs();
        boolean hasUnsupportedCriticalExtensions = x509Certificate.hasUnsupportedCriticalExtension();
        return new CertificateData(type, encoded, version, subjectDN, issuerDN, serialNumber, notBefore, notAfter, publicKeyData, sigAlgName, sigAlgOID, sigAlgParams, signature, basicConstraints, extendedKeyUsage, keyUsage, issuerUniqueID, subjectAlternativeNames, issuerAlternativeNames, extensions, criticalOids, nonCriticalOids, hasUnsupportedCriticalExtensions);
    }

    private static String parseSubjectAlternativeName(X509Certificate certificate) {
        StringBuilder sb = new StringBuilder();
        try {
            Collection<List<?>> subjectAlternativeNames = certificate.getSubjectAlternativeNames();
            if (subjectAlternativeNames != null) {
                block6: for (List<?> san : subjectAlternativeNames) {
                    Integer type = (Integer)san.get(0);
                    String value = san.get(1).toString();
                    switch (type) {
                        case 2: {
                            sb.append("  DNSName: ").append(value).append("\n");
                            continue block6;
                        }
                        case 7: {
                            sb.append("  IPAddress: ").append(value).append("\n");
                            continue block6;
                        }
                    }
                    sb.append("  OtherName: ").append(value).append("\n");
                }
            }
        }
        catch (CertificateParsingException e) {
            sb.append("  Error parsing Subject Alternative Name: ").append(e.getMessage()).append("\n");
        }
        return sb.toString();
    }

    private static byte[] decodeExtensionValue(byte[] extensionValue) {
        int length;
        if (extensionValue[0] == 4 && (length = extensionValue[1] & 0xFF) == extensionValue.length - 2) {
            int innerLength = extensionValue[3] & 0xFF;
            byte[] value = new byte[innerLength];
            System.arraycopy(extensionValue, 4, value, 0, innerLength);
            return value;
        }
        return extensionValue;
    }
}

