/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.api.certificate;

import com.mulesoft.connectors.mcp.api.certificate.AlternativeNameData;
import com.mulesoft.connectors.mcp.api.certificate.CertificateExtension;
import com.mulesoft.connectors.mcp.api.certificate.PrincipalData;
import com.mulesoft.connectors.mcp.api.certificate.PublicKeyData;
import com.mulesoft.connectors.mcp.api.certificate.SerialNumberData;
import com.mulesoft.connectors.mcp.api.certificate.X500PrincipalData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CertificateData
implements Serializable {
    private static final long serialVersionUID = -1585440601605666277L;
    private String type;
    private byte[] encoded;
    private int version;
    private PrincipalData subjectDN;
    private PrincipalData issuerDN;
    private BigInteger serialNumber;
    private Date notBefore;
    private Date notAfter;
    private PublicKeyData publicKey;
    private String sigAlgName;
    private String sigAlgOID;
    private byte[] sigAlgParams;
    private byte[] signature;
    private int basicConstraints;
    private List<String> extendedKeyUsage;
    private boolean[] keyUsage;
    private boolean[] issuerUniqueID;
    private List<AlternativeNameData> subjectAlternativeNames;
    private List<AlternativeNameData> issuerAlternativeNames;
    private List<CertificateExtension> extensions;
    private Set<String> criticalOids = new HashSet<String>();
    private Set<String> nonCriticalOids = new HashSet<String>();
    private boolean hasUnsupportedCriticalExtensions;

    public CertificateData(String type, byte[] encoded) {
        this.type = type;
        this.encoded = encoded;
    }

    public CertificateData(String type, byte[] encoded, int version, PrincipalData subjectDN, PrincipalData issuerDN, BigInteger serialNumber, Date notBefore, Date notAfter, PublicKeyData publicKey, String sigAlgName, String sigAlgOID, byte[] sigAlgParams, byte[] signature, int basicConstraints, List<String> extendedKeyUsage, boolean[] keyUsage, boolean[] issuerUniqueID, List<AlternativeNameData> subjectAlternativeNames, List<AlternativeNameData> issuerAlternativeNames, List<CertificateExtension> extensions, Set<String> criticalOids, Set<String> nonCriticalOids, boolean hasUnsupportedCriticalExtensions) {
        this.type = type;
        this.encoded = encoded;
        this.version = version;
        this.subjectDN = subjectDN;
        this.issuerDN = issuerDN;
        this.serialNumber = serialNumber;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.publicKey = publicKey;
        this.sigAlgName = sigAlgName;
        this.sigAlgOID = sigAlgOID;
        this.sigAlgParams = sigAlgParams;
        this.signature = signature;
        this.basicConstraints = basicConstraints;
        this.extendedKeyUsage = extendedKeyUsage;
        this.keyUsage = keyUsage;
        this.issuerUniqueID = issuerUniqueID;
        this.subjectAlternativeNames = subjectAlternativeNames;
        this.issuerAlternativeNames = issuerAlternativeNames;
        this.extensions = extensions;
        this.criticalOids = criticalOids;
        this.nonCriticalOids = nonCriticalOids;
        this.hasUnsupportedCriticalExtensions = hasUnsupportedCriticalExtensions;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.getSubjectDN().getName();
    }

    public int getVersion() {
        return this.version;
    }

    public PrincipalData getSubjectDN() {
        return this.subjectDN;
    }

    public PrincipalData getIssuerDN() {
        return this.issuerDN;
    }

    public X500PrincipalData getSubjectX500Principal() {
        return new X500PrincipalData(this.subjectDN);
    }

    public X500PrincipalData getIssuerX500Principal() {
        return new X500PrincipalData(this.issuerDN);
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public SerialNumberData getSerialNumberObject() {
        return new SerialNumberData(this.serialNumber);
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getNotAfter() {
        return this.notAfter;
    }

    public PublicKeyData getPublicKey() {
        return this.publicKey;
    }

    public String getSigAlgName() {
        return this.sigAlgName;
    }

    public String getSigAlgOID() {
        return this.sigAlgOID;
    }

    public byte[] getSigAlgParams() {
        return this.sigAlgParams;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public List<String> getExtendedKeyUsage() {
        return this.extendedKeyUsage;
    }

    public boolean[] getKeyUsage() {
        return this.keyUsage;
    }

    public List<AlternativeNameData> getSubjectAlternativeNames() {
        return this.subjectAlternativeNames;
    }

    public List<AlternativeNameData> getIssuerAlternativeNames() {
        return this.issuerAlternativeNames;
    }

    public List<CertificateExtension> getExtensions() {
        return this.extensions;
    }

    public byte[] getExtensionValue(String oid) {
        for (CertificateExtension ext : this.extensions) {
            if (!ext.getOid().equals(oid)) continue;
            return ext.getValue();
        }
        throw new IllegalArgumentException("Extension with OID " + oid + " not found");
    }

    public Set<String> getCriticalExtensionOIDs() {
        return new HashSet<String>(this.criticalOids);
    }

    public Set<String> getNonCriticalExtensionOIDs() {
        return new HashSet<String>(this.nonCriticalOids);
    }

    public boolean hasUnsupportedCriticalExtension() {
        return this.hasUnsupportedCriticalExtensions;
    }

    public boolean[] getIssuerUniqueID() {
        return this.issuerUniqueID;
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date now = new Date();
        this.checkValidity(now);
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.before(this.notBefore)) {
            throw new CertificateNotYetValidException("Certificate is not valid yet: " + String.valueOf(date));
        }
        if (date.after(this.notAfter)) {
            throw new CertificateExpiredException("Certificate has expired: " + String.valueOf(date));
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.encoded);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CertificateData other = (CertificateData)obj;
        return Arrays.equals(this.encoded, other.encoded);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[\n[\n  Version: V").append(this.version).append("\n");
        sb.append("  Subject: ").append(this.subjectDN.toString()).append("\n");
        sb.append("  Signature Algorithm: ").append(this.sigAlgName).append(", OID = ").append(this.sigAlgOID).append("\n\n");
        sb.append("  Key:  ").append(this.publicKey.toString().replaceAll("\n", "\n")).append("\n");
        sb.append("  Validity: [From: ").append(this.notBefore).append(",\n");
        sb.append("               To: ").append(this.notAfter).append("]\n");
        sb.append("  Issuer: ").append(this.issuerDN.toString()).append("\n");
        sb.append("  SerialNumber: [    ").append(this.serialNumber.toString(16)).append("]\n\n");
        if (!this.extensions.isEmpty()) {
            sb.append("Certificate Extensions: ").append(this.extensions.size()).append("\n");
            for (int i = 0; i < this.extensions.size(); ++i) {
                CertificateExtension ext = this.extensions.get(i);
                sb.append("[").append(i + 1).append("]: ");
                sb.append(ext.toString()).append("\n");
            }
        } else {
            sb.append("  Certificate Extensions: 0\n");
        }
        sb.append("  Algorithm: [").append(this.sigAlgName).append("]\n");
        sb.append("  Signature:\n").append(CertificateData.formatSignature(this.signature)).append("\n");
        sb.append("]");
        return sb.toString();
    }

    public static String formatSignature(byte[] signature) {
        StringBuilder sb = new StringBuilder();
        StringBuilder asciiPart = new StringBuilder();
        for (int i = 0; i < signature.length; ++i) {
            if (i % 16 == 0) {
                if (i != 0) {
                    sb.append(" ").append((CharSequence)asciiPart).append("\n");
                    asciiPart.setLength(0);
                }
                sb.append(String.format("%04X: ", i));
            }
            sb.append(String.format("%02X ", signature[i]));
            if (signature[i] >= 32 && signature[i] < 125) {
                asciiPart.append((char)signature[i]);
            } else {
                asciiPart.append('.');
            }
            if ((i + 1) % 8 != 0 || (i + 1) % 16 == 0) continue;
            sb.append("  ");
        }
        int remainingBytes = signature.length % 16;
        if (remainingBytes != 0) {
            int padding = (16 - remainingBytes) * 3;
            if (remainingBytes <= 8) {
                ++padding;
            }
            sb.append(CertificateData.repeatSpace(padding)).append(" ").append((CharSequence)asciiPart);
        } else {
            sb.append(" ").append((CharSequence)asciiPart);
        }
        sb.append("\n");
        return sb.toString();
    }

    private static String repeatSpace(int count) {
        char[] chars = new char[count];
        Arrays.fill(chars, ' ');
        return new String(chars);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public byte[] getEncoded() throws CertificateEncodingException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            byte[] byArray;
            try (ObjectOutputStream oos = new ObjectOutputStream(baos);){
                oos.writeObject(this.type);
                oos.writeObject(this.encoded);
                oos.writeObject(this.version);
                oos.writeObject(this.subjectDN != null ? this.subjectDN : "null");
                oos.writeObject(this.issuerDN != null ? this.issuerDN : "null");
                oos.writeObject(this.serialNumber != null ? this.serialNumber : "null");
                oos.writeObject(this.notBefore != null ? this.notBefore : "null");
                oos.writeObject(this.notAfter != null ? this.notAfter : "null");
                oos.writeObject(this.publicKey != null ? this.publicKey : "null");
                oos.writeObject(this.sigAlgName != null ? this.sigAlgName : "null");
                oos.writeObject(this.sigAlgOID != null ? this.sigAlgOID : "null");
                oos.writeObject(this.sigAlgParams != null ? (Object)this.sigAlgParams : "null");
                oos.writeObject(this.signature != null ? (Object)this.signature : "null");
                oos.writeObject(this.basicConstraints);
                oos.writeObject(this.extendedKeyUsage != null ? this.extendedKeyUsage : "null");
                oos.writeObject(this.keyUsage != null ? (Object)this.keyUsage : "null");
                oos.writeObject(this.issuerUniqueID != null ? (Object)this.issuerUniqueID : "null");
                oos.writeObject(this.subjectAlternativeNames != null ? this.subjectAlternativeNames : "null");
                oos.writeObject(this.issuerAlternativeNames != null ? this.issuerAlternativeNames : "null");
                oos.writeObject(this.extensions != null ? this.extensions : "null");
                oos.flush();
                byArray = baos.toByteArray();
            }
            return byArray;
        }
        catch (IOException e) {
            throw new CertificateEncodingException("Failed to encode certificate", e);
        }
    }
}

