/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal;

import com.mulesoft.connectors.mcp.internal.client.ClientConfig;
import com.mulesoft.connectors.mcp.internal.server.config.ServerConfig;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class ConfigTracker {
    private Map<String, ServerConfig> serverConfigs = new ConcurrentHashMap<String, ServerConfig>();
    private Map<String, ClientConfig> clientConfigs = new ConcurrentHashMap<String, ClientConfig>();

    public void register(ServerConfig serverConfig) {
        this.serverConfigs.put(serverConfig.getRefName(), serverConfig);
    }

    public void register(ClientConfig clientConfig) {
        this.clientConfigs.put(clientConfig.getRefName(), clientConfig);
    }

    public Optional<ServerConfig> getServerConfig(String refName) {
        return Optional.ofNullable(this.serverConfigs.get(refName));
    }

    public Optional<ClientConfig> getClientConfig(String refName) {
        return Optional.ofNullable(this.clientConfigs.get(refName));
    }

    public void unregister(ServerConfig serverConfig) {
        this.serverConfigs.remove(serverConfig.getRefName());
    }

    public void unregister(ClientConfig clientConfig) {
        this.clientConfigs.remove(clientConfig.getRefName());
    }
}

