/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal;

import com.mulesoft.connectors.mcp.internal.server.connection.observer.InboundRequestContext;
import com.mulesoft.connectors.mcp.internal.server.connection.observer.OutboundRequestContext;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.mule.runtime.api.util.Reference;

public class MessagingManager {
    private final ThreadLocal<InboundRequestContext> inboundRequests = new ThreadLocal();
    private final Map<Reference<Object>, OutboundRequestContext> outboundRequests = new ConcurrentHashMap<Reference<Object>, OutboundRequestContext>();

    public void track(InboundRequestContext requestContext) {
        if (this.shouldTrack(requestContext)) {
            this.inboundRequests.set(requestContext);
        }
    }

    public void track(OutboundRequestContext responseContext) {
        this.outboundRequests.put((Reference<Object>)new Reference(responseContext.getMessage()), responseContext);
    }

    public Optional<InboundRequestContext> popInbound() {
        try {
            Optional<InboundRequestContext> optional = Optional.ofNullable(this.inboundRequests.get());
            return optional;
        }
        finally {
            this.inboundRequests.remove();
        }
    }

    public Optional<OutboundRequestContext> popOutbound(Object message) {
        if (message instanceof McpSchema.JSONRPCRequest) {
            McpSchema.JSONRPCRequest request = (McpSchema.JSONRPCRequest)message;
            message = request.params();
        }
        return Optional.ofNullable(this.outboundRequests.remove(new Reference(message)));
    }

    public void untrackOutbound(Object message) {
        this.outboundRequests.remove(new Reference(message));
    }

    private boolean shouldTrack(InboundRequestContext request) {
        String method = ((McpSchema.JSONRPCRequest)request.getMessage()).method();
        return "tools/call".equals(method) || "resources/read".equals(method);
    }
}

