/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.client.connection.provider;

import com.mulesoft.connectors.mcp.internal.ConfigTracker;
import com.mulesoft.connectors.mcp.internal.MessagingManager;
import com.mulesoft.connectors.mcp.internal.client.ClientConfig;
import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.client.McpClient;
import io.modelcontextprotocol.spec.McpClientTransport;
import io.modelcontextprotocol.spec.McpSchema;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.extension.http.api.request.authentication.HttpRequestAuthentication;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.client.HttpClient;
import org.mule.runtime.http.api.client.HttpClientConfiguration;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.annotation.param.RefName;
import org.mule.sdk.api.annotation.param.display.Summary;
import org.mule.sdk.api.connectivity.CachedConnectionProvider;
import org.mule.sdk.api.connectivity.ConnectionValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpClientConnectionProvider
implements CachedConnectionProvider<McpAsyncClient>,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractHttpClientConnectionProvider.class);
    @Inject
    protected HttpService httpService;
    @Inject
    protected ConfigTracker configTracker;
    @Inject
    protected MessagingManager messagingManager;
    @Inject
    protected MuleContext muleContext;
    @RefName
    protected String refName;
    @Parameter
    @Optional(defaultValue="30")
    @Summary(value="Sets the duration to wait for server responses before timing out requests.")
    protected Integer requestTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Summary(value="Time Unit for the requestTimeout parameter")
    protected TimeUnit requestTimeoutUnit;
    @Parameter
    @Optional
    protected TlsContextFactory tlsContextFactory;
    @Parameter
    @Optional
    @Placement(tab="Authentication")
    protected HttpRequestAuthentication authentication;
    @Parameter
    @Optional
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced")
    @NullSafe
    protected MultiMap<String, String> defaultRequestHeaders = MultiMap.emptyMultiMap();
    protected HttpClient httpClient;

    protected abstract McpClientTransport createClientTransport();

    public final McpAsyncClient connect() throws ConnectionException {
        ClientConfig clientConfig = this.getClientConfig();
        McpClientTransport transport = this.createClientTransport();
        McpAsyncClient client = McpClient.async((McpClientTransport)transport).requestTimeout(Duration.of(this.requestTimeout.intValue(), this.requestTimeoutUnit.toChronoUnit())).clientInfo(new McpSchema.Implementation(clientConfig.getClientName(), clientConfig.getClientVersion())).build();
        try {
            client.initialize().block();
        }
        catch (Exception e) {
            throw new ConnectionException((Throwable)e);
        }
        return client;
    }

    public void disconnect(McpAsyncClient client) {
        try {
            client.closeGracefully();
        }
        catch (Exception e) {
            LOGGER.error("Error closing connection", (Throwable)e);
        }
    }

    public ConnectionValidationResult validate(McpAsyncClient client) {
        try {
            client.ping().block();
            return ConnectionValidationResult.success();
        }
        catch (Exception e) {
            return ConnectionValidationResult.failure((String)e.getMessage(), (Exception)e);
        }
    }

    private ClientConfig getClientConfig() {
        return this.configTracker.getClientConfig(this.refName).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)("Could not find config " + this.refName))));
    }

    public final void initialise() throws InitialisationException {
        if (this.tlsContextFactory != null) {
            LOGGER.debug("Initializing TLS context factory for connection provider '{}'", (Object)this.refName);
            try {
                LifecycleUtils.initialiseIfNeeded((Object)this.tlsContextFactory);
                LOGGER.debug("TLS context factory initialized successfully for '{}'", (Object)this.refName);
            }
            catch (Exception e) {
                LOGGER.error("Failed to initialize TLS context factory for '{}': {}", new Object[]{this.refName, e.getMessage(), e});
                throw new InitialisationException(I18nMessageFactory.createStaticMessage((String)"Failed to initialize TLS context factory"), (Throwable)e, (Initialisable)this);
            }
        } else {
            LOGGER.debug("No TLS context factory provided for connection provider '{}'", (Object)this.refName);
        }
        LifecycleUtils.initialiseIfNeeded((Object)this.authentication, (boolean)true, (MuleContext)this.muleContext);
    }

    public final void start() throws MuleException {
        if (this.tlsContextFactory != null) {
            LOGGER.debug("Configuring HTTP client with TLS for '{}'", (Object)this.refName);
        }
        this.httpClient = this.httpService.getClientFactory().create(new HttpClientConfiguration.Builder().setName("mcp-http-client-" + this.refName).setStreaming(true).setTlsContextFactory(this.tlsContextFactory).build());
        this.httpClient.start();
        LifecycleUtils.startIfNeeded((Object)this.authentication);
    }

    public final void stop() throws MuleException {
        if (this.httpClient != null) {
            this.httpClient.stop();
        }
        LifecycleUtils.stopIfNeeded((Object)this.authentication);
    }

    public final void dispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.authentication, (Logger)LOGGER);
    }
}

