/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.client.operation.resource;

import com.mulesoft.connectors.mcp.api.client.resource.ResourceMetadata;
import com.mulesoft.connectors.mcp.api.client.resource.ResourceTemplateMetadata;
import com.mulesoft.connectors.mcp.api.client.tool.ResourceContent;
import com.mulesoft.connectors.mcp.internal.McpUtils;
import com.mulesoft.connectors.mcp.internal.MessagingManager;
import com.mulesoft.connectors.mcp.internal.client.operation.RequestParameterGroup;
import com.mulesoft.connectors.mcp.internal.client.operation.tool.McpPagingProvider;
import com.mulesoft.connectors.mcp.internal.design.vp.ResourceUriValueProvider;
import com.mulesoft.connectors.mcp.internal.error.McpErrorTypes;
import com.mulesoft.connectors.mcp.internal.error.provider.BasicOperationErrorTypeProvider;
import com.mulesoft.connectors.mcp.internal.error.provider.JsonRpcErrorTypeProvider;
import com.mulesoft.connectors.mcp.internal.error.provider.ResourceErrorTypeProvider;
import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.annotation.Ignore;
import org.mule.sdk.api.annotation.error.Throws;
import org.mule.sdk.api.annotation.param.Connection;
import org.mule.sdk.api.annotation.param.ParameterGroup;
import org.mule.sdk.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.annotation.values.OfValues;
import org.mule.sdk.api.error.ErrorTypeDefinition;
import org.mule.sdk.api.exception.ModuleException;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

@Throws(value={JsonRpcErrorTypeProvider.class, BasicOperationErrorTypeProvider.class, ResourceErrorTypeProvider.class})
public class ClientResourceOperations {
    @Inject
    private MessagingManager messagingManager;

    @DisplayName(value="MCP Client - Read Resource")
    public void readResource(@Connection McpAsyncClient client, @OfValues(value=ResourceUriValueProvider.class) String uri, @ParameterGroup(name="Request") RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager, CompletionCallback<ResourceContent, Void> completionCallback) {
        McpSchema.ReadResourceRequest message = new McpSchema.ReadResourceRequest(uri);
        requestParameters.track(message, this.messagingManager, traceContextManager);
        client.readResource(message).doOnNext(response -> {
            try {
                ResourceContent resource = this.parseResource((McpSchema.ReadResourceResult)response);
                completionCallback.success(Result.builder().output((Object)resource).build());
            }
            catch (Exception e) {
                completionCallback.error((Throwable)e);
            }
        }).doOnError(arg_0 -> completionCallback.error(arg_0)).doFinally(s -> this.messagingManager.untrackOutbound(message)).subscribe();
    }

    private ResourceContent parseResource(McpSchema.ReadResourceResult response) {
        if (response.contents().isEmpty()) {
            throw new ModuleException("Resource has no content", (ErrorTypeDefinition)McpErrorTypes.INTERNAL_ERROR);
        }
        ResourceContent resource = new ResourceContent();
        McpSchema.ResourceContents content = (McpSchema.ResourceContents)response.contents().get(0);
        resource.setUri(content.uri());
        resource.setMimeType(content.mimeType());
        if (content instanceof McpSchema.TextResourceContents) {
            McpSchema.TextResourceContents text = (McpSchema.TextResourceContents)content;
            resource.setText(text.text());
        } else if (content instanceof McpSchema.BlobResourceContents) {
            McpSchema.BlobResourceContents blob = (McpSchema.BlobResourceContents)content;
            resource.setBlob(McpUtils.fromBase64(blob.blob()));
        } else {
            throw new ModuleException("Unsupported resource content type: " + String.valueOf(content.getClass()), (ErrorTypeDefinition)McpErrorTypes.INTERNAL_ERROR);
        }
        return resource;
    }

    @DisplayName(value="MCP Client - List Resources")
    public PagingProvider<McpAsyncClient, ResourceMetadata> listResources() {
        return new McpPagingProvider<ResourceMetadata, McpSchema.ListResourcesResult>(){

            @Override
            protected McpSchema.ListResourcesResult requestNextPage(McpAsyncClient client, String cursor) {
                return (McpSchema.ListResourcesResult)client.listResources(cursor).block();
            }

            @Override
            protected List<ResourceMetadata> asPage(McpSchema.ListResourcesResult result) {
                return result.resources().stream().map(resource -> new ResourceMetadata(resource.uri(), resource.name(), resource.description(), resource.mimeType())).collect(Collectors.toList());
            }

            @Override
            protected String getNextCursor(McpSchema.ListResourcesResult result) {
                return result.nextCursor();
            }
        };
    }

    @Ignore
    public PagingProvider<McpAsyncClient, ResourceTemplateMetadata> listResourceTemplates() {
        return new McpPagingProvider<ResourceTemplateMetadata, McpSchema.ListResourceTemplatesResult>(){

            @Override
            protected McpSchema.ListResourceTemplatesResult requestNextPage(McpAsyncClient client, String cursor) {
                return (McpSchema.ListResourceTemplatesResult)client.listResourceTemplates(cursor).block();
            }

            @Override
            protected List<ResourceTemplateMetadata> asPage(McpSchema.ListResourceTemplatesResult result) {
                return result.resourceTemplates().stream().map(resource -> new ResourceTemplateMetadata(resource.uriTemplate(), resource.name(), resource.description(), resource.mimeType())).collect(Collectors.toList());
            }

            @Override
            protected String getNextCursor(McpSchema.ListResourceTemplatesResult result) {
                return result.nextCursor();
            }
        };
    }
}

