/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.client.operation.tool;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.connectors.mcp.api.client.tool.CallToolResponse;
import com.mulesoft.connectors.mcp.api.client.tool.CallToolResponseContent;
import com.mulesoft.connectors.mcp.api.client.tool.ResourceContent;
import com.mulesoft.connectors.mcp.api.client.tool.ToolContentType;
import com.mulesoft.connectors.mcp.api.client.tool.ToolMetadata;
import com.mulesoft.connectors.mcp.internal.McpUtils;
import com.mulesoft.connectors.mcp.internal.MessagingManager;
import com.mulesoft.connectors.mcp.internal.client.operation.RequestParameterGroup;
import com.mulesoft.connectors.mcp.internal.client.operation.tool.McpPagingProvider;
import com.mulesoft.connectors.mcp.internal.client.operation.tool.datasense.ClientToolInputTypeResolver;
import com.mulesoft.connectors.mcp.internal.client.operation.tool.datasense.ClientToolKeyResolver;
import com.mulesoft.connectors.mcp.internal.error.McpErrorTypes;
import com.mulesoft.connectors.mcp.internal.error.provider.BasicOperationErrorTypeProvider;
import com.mulesoft.connectors.mcp.internal.error.provider.JsonRpcErrorTypeProvider;
import com.mulesoft.connectors.mcp.internal.jackson.ObjectMapperFactory;
import io.modelcontextprotocol.client.McpAsyncClient;
import io.modelcontextprotocol.spec.McpSchema;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.sdk.api.annotation.error.Throws;
import org.mule.sdk.api.annotation.metadata.MetadataKeyId;
import org.mule.sdk.api.annotation.metadata.TypeResolver;
import org.mule.sdk.api.annotation.param.Connection;
import org.mule.sdk.api.annotation.param.Content;
import org.mule.sdk.api.annotation.param.ParameterGroup;
import org.mule.sdk.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.error.ErrorTypeDefinition;
import org.mule.sdk.api.exception.ModuleException;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;

@Throws(value={JsonRpcErrorTypeProvider.class, BasicOperationErrorTypeProvider.class})
public class ClientToolOperations {
    private final ObjectMapper objectMapper = ObjectMapperFactory.get();
    @Inject
    private MessagingManager messagingManager;

    @DisplayName(value="MCP Client - Call Tool")
    public void callTool(@Connection McpAsyncClient client, @MetadataKeyId(value=ClientToolKeyResolver.class) String toolName, @Content(primary=true) @TypeResolver(value=ClientToolInputTypeResolver.class) Map<String, Object> arguments, @ParameterGroup(name="Request") RequestParameterGroup requestParameters, DistributedTraceContextManager traceContextManager, CompletionCallback<CallToolResponse, Void> completionCallback) {
        McpSchema.CallToolRequest message = new McpSchema.CallToolRequest(toolName, arguments);
        requestParameters.track(message, this.messagingManager, traceContextManager);
        client.callTool(message).doOnNext(result -> completionCallback.success(Result.builder().output((Object)this.toResponse((McpSchema.CallToolResult)result)).mediaType(MediaType.APPLICATION_JAVA).build())).doOnError(arg_0 -> completionCallback.error(arg_0)).doFinally(s -> this.messagingManager.untrackOutbound(message)).subscribe();
    }

    private CallToolResponse toResponse(McpSchema.CallToolResult result) {
        return new CallToolResponse(this.getToolContents(result), result.isError() != null ? result.isError() : false);
    }

    private List<CallToolResponseContent> getToolContents(McpSchema.CallToolResult response) {
        return response.content().stream().map(content -> {
            CallToolResponseContent result = new CallToolResponseContent();
            result.setType(ToolContentType.valueOf(content.type()));
            if (content instanceof McpSchema.TextContent) {
                McpSchema.TextContent textContent = (McpSchema.TextContent)content;
                result.setText(textContent.text());
                result.setAudience(McpUtils.fromMcpRoles(textContent.audience()));
                result.setPriority(textContent.priority());
                return result;
            } else if (content instanceof McpSchema.ImageContent) {
                McpSchema.ImageContent imageContent = (McpSchema.ImageContent)content;
                result.setData(McpUtils.fromBase64(imageContent.data()));
                result.setMimeType(imageContent.mimeType());
                result.setAudience(McpUtils.fromMcpRoles(imageContent.audience()));
                result.setPriority(imageContent.priority());
                return result;
            } else {
                if (!(content instanceof McpSchema.EmbeddedResource)) throw new IllegalArgumentException("Unsupported content type: " + String.valueOf(content));
                McpSchema.EmbeddedResource embeddedResource = (McpSchema.EmbeddedResource)content;
                result.setAudience(McpUtils.fromMcpRoles(embeddedResource.audience()));
                result.setPriority(embeddedResource.priority());
                ResourceContent resource = new ResourceContent();
                result.setResource(resource);
                McpSchema.ResourceContents resourceContents = embeddedResource.resource();
                if (resourceContents instanceof McpSchema.TextResourceContents) {
                    McpSchema.TextResourceContents textResource = (McpSchema.TextResourceContents)resourceContents;
                    resource.setText(textResource.text());
                    resource.setUri(textResource.uri());
                    resource.setMimeType(textResource.mimeType());
                    return result;
                } else {
                    if (!(resourceContents instanceof McpSchema.BlobResourceContents)) throw new IllegalArgumentException("Unsupported embedded resource type: " + String.valueOf(resourceContents));
                    McpSchema.BlobResourceContents blobResource = (McpSchema.BlobResourceContents)resourceContents;
                    resource.setUri(blobResource.uri());
                    resource.setMimeType(blobResource.mimeType());
                    resource.setBlob(McpUtils.fromBase64(blobResource.blob()));
                }
            }
            return result;
        }).toList();
    }

    @DisplayName(value="MCP Client - List Tools")
    public PagingProvider<McpAsyncClient, ToolMetadata> listTools() {
        return new McpPagingProvider<ToolMetadata, McpSchema.ListToolsResult>(){

            @Override
            protected McpSchema.ListToolsResult requestNextPage(McpAsyncClient client, String nextCursor) {
                return (McpSchema.ListToolsResult)client.listTools(nextCursor).block();
            }

            @Override
            protected List<ToolMetadata> asPage(McpSchema.ListToolsResult result) {
                return result.tools().stream().map(tool -> {
                    try {
                        return new ToolMetadata(tool.name(), tool.description(), ClientToolOperations.this.objectMapper.writeValueAsString((Object)tool.inputSchema()));
                    }
                    catch (JsonProcessingException e) {
                        throw new ModuleException("Error parsing tool json schema", (ErrorTypeDefinition)McpErrorTypes.PARSE_ERROR, (Throwable)e);
                    }
                }).toList();
            }

            @Override
            protected String getNextCursor(McpSchema.ListToolsResult result) {
                return result.nextCursor();
            }
        };
    }
}

