/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.connection.provider;

import com.mulesoft.connectors.mcp.internal.ConfigTracker;
import com.mulesoft.connectors.mcp.internal.MessagingManager;
import com.mulesoft.connectors.mcp.internal.server.config.ServerConfig;
import com.mulesoft.connectors.mcp.internal.server.connection.provider.BaseServerTransportProvider;
import io.modelcontextprotocol.server.McpAsyncServer;
import io.modelcontextprotocol.server.McpServer;
import io.modelcontextprotocol.spec.McpSchema;
import io.modelcontextprotocol.spec.McpServerTransportProvider;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.display.Placement;
import org.mule.sdk.api.annotation.param.RefName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class McpServerConnectionProvider
implements CachedConnectionProvider<McpAsyncServer>,
Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(McpServerConnectionProvider.class);
    @RefName
    protected String configName;
    @Inject
    protected ConfigTracker configTracker;
    @Inject
    private MessagingManager messagingManager;
    @Inject
    private SchedulerService schedulerService;
    @Parameter
    @Optional(defaultValue="10")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced")
    private Long requestTimeout;
    @Parameter
    @Optional(defaultValue="SECONDS")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Placement(tab="Advanced")
    private TimeUnit requestTimeoutUnit;
    private Scheduler scheduler;

    protected Scheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = this.schedulerService.ioScheduler(SchedulerConfig.config().withName("mcp-server-scheduler-" + this.configName));
        }
        return this.scheduler;
    }

    public final void stop() throws MuleException {
        try {
            this.doStop();
        }
        finally {
            if (this.scheduler != null) {
                this.scheduler.shutdown();
            }
        }
    }

    protected void doStop() throws MuleException {
    }

    public final McpAsyncServer connect() throws ConnectionException {
        ServerConfig config = this.getServerConfig();
        try {
            BaseServerTransportProvider transportProvider = this.createTransportProvider();
            transportProvider.onRPCRequest(this.messagingManager::track);
            transportProvider.open();
            McpAsyncServer server = McpServer.async((McpServerTransportProvider)transportProvider).requestTimeout(Duration.of(this.requestTimeout, this.requestTimeoutUnit.toChronoUnit())).serverInfo(config.getServerName(), config.getServerVersion()).capabilities(new McpSchema.ServerCapabilities(null, Collections.emptyMap(), null, null, new McpSchema.ServerCapabilities.ResourceCapabilities(Boolean.valueOf(false), Boolean.valueOf(false)), new McpSchema.ServerCapabilities.ToolCapabilities(Boolean.valueOf(false)))).build();
            config.setTransport(transportProvider);
            return server;
        }
        catch (ConnectionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConnectionException((Throwable)e);
        }
    }

    private ServerConfig getServerConfig() {
        return this.configTracker.getServerConfig(this.configName).orElseThrow(() -> new IllegalStateException("Could not find config named: " + this.configName));
    }

    public final void disconnect(McpAsyncServer server) {
        try {
            server.closeGracefully();
        }
        catch (Throwable e) {
            LOGGER.error("Error closing server for config '{}'", (Object)this.configName, (Object)e);
        }
        finally {
            this.getServerConfig().setTransport(null);
        }
    }

    protected abstract BaseServerTransportProvider createTransportProvider() throws ConnectionException;
}

