/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.connection.provider.streamable;

import com.mulesoft.connectors.mcp.api.server.StreamableMimeType;
import com.mulesoft.connectors.mcp.internal.server.connection.MuleServerSession;
import com.mulesoft.connectors.mcp.internal.server.connection.provider.BaseServerTransportProvider;
import com.mulesoft.connectors.mcp.internal.server.connection.provider.McpServerConnectionProvider;
import com.mulesoft.connectors.mcp.internal.server.connection.provider.streamable.SessionHandlingParameterGroup;
import com.mulesoft.connectors.mcp.internal.server.connection.provider.streamable.StreamableHttpServerTransportProvider;
import com.mulesoft.connectors.mcp.internal.server.session.DistributedL2SessionManager;
import com.mulesoft.connectors.mcp.internal.server.session.SessionManager;
import io.modelcontextprotocol.server.McpAsyncServer;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.store.ObjectStoreException;
import org.mule.runtime.api.store.ObjectStoreManager;
import org.mule.runtime.api.store.ObjectStoreSettings;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.core.api.config.MuleConfiguration;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.display.Summary;
import org.mule.runtime.extension.api.annotation.param.reference.ConfigReference;
import org.mule.runtime.http.api.HttpService;
import org.mule.runtime.http.api.server.HttpServer;
import org.mule.runtime.http.api.server.ServerNotFoundException;
import org.mule.sdk.api.annotation.Alias;
import org.mule.sdk.api.annotation.Expression;
import org.mule.sdk.api.annotation.param.NullSafe;
import org.mule.sdk.api.annotation.param.Optional;
import org.mule.sdk.api.annotation.param.Parameter;
import org.mule.sdk.api.connectivity.NoConnectivityTest;
import org.mule.sdk.api.meta.ExpressionSupport;

@Alias(value="streamable-http-server")
public class StreamableHttpServerConnectionProvider
extends McpServerConnectionProvider
implements NoConnectivityTest {
    @Inject
    private HttpService httpService;
    @Inject
    private ObjectStoreManager objectStoreManager;
    @Inject
    private MuleConfiguration muleConfiguration;
    @Inject
    private LockFactory lockFactory;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @ConfigReference(name="LISTENER_CONFIG", namespace="HTTP")
    @Summary(value="Reference to the <http:listener-config> used to expose the inbound endpoint")
    private String listenerConfig;
    @Parameter
    @Optional(defaultValue="/mcp")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private String mcpEndpointPath;
    @Parameter
    @Optional(defaultValue="SSE")
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private StreamableMimeType responseContentType = StreamableMimeType.SSE;
    @Parameter
    @Optional
    @NullSafe
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private MultiMap<String, String> defaultResponseHeaders = MultiMap.emptyMultiMap();
    @ParameterGroup(name="Session Handling", showInDsl=true)
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    private SessionHandlingParameterGroup sessionHandling;

    @Override
    protected BaseServerTransportProvider createTransportProvider() throws ConnectionException {
        try {
            HttpServer httpServer = this.httpService.getServerFactory().lookup(this.listenerConfig);
            return new StreamableHttpServerTransportProvider(this.configName, httpServer, this.getScheduler(), this.mcpEndpointPath, this.responseContentType, this.createSessionManager(), this.defaultResponseHeaders);
        }
        catch (ServerNotFoundException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not find <http:listener-config> named '%s'".formatted(this.listenerConfig), (Object[])new Object[]{e}));
        }
        catch (ObjectStoreException e) {
            throw new ConnectionException("Could not open sessions object store", (Throwable)e);
        }
    }

    private SessionManager createSessionManager() throws ObjectStoreException {
        ObjectStore sessionObjectStore = this.sessionHandling.getSessionsObjectStore();
        if (sessionObjectStore == null) {
            sessionObjectStore = this.objectStoreManager.getOrCreateObjectStore("mcp-server-sessions-" + this.muleConfiguration.getId() + "-" + this.configName, ObjectStoreSettings.builder().persistent(false).build());
            sessionObjectStore.open();
        }
        return new DistributedL2SessionManager(this.configName, (ObjectStore<MuleServerSession>)sessionObjectStore, this.lockFactory, this.sessionHandling.getSessionIdleTimeoutMillis());
    }

    public ConnectionValidationResult validate(McpAsyncServer server) {
        return ConnectionValidationResult.success();
    }
}

