/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.server.source.session;

import com.mulesoft.connectors.mcp.api.connection.NewSessionRequest;
import com.mulesoft.connectors.mcp.internal.server.config.ServerConfig;
import com.mulesoft.connectors.mcp.internal.server.connection.observer.InternalNewSessionRequest;
import com.mulesoft.connectors.mcp.internal.server.source.session.RejectNewSessionParameterGroup;
import io.modelcontextprotocol.server.McpAsyncServer;
import java.util.concurrent.CompletableFuture;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.sdk.api.annotation.param.Config;
import org.mule.sdk.api.annotation.param.Connection;
import org.mule.sdk.api.annotation.param.ParameterGroup;
import org.mule.sdk.api.annotation.param.display.DisplayName;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.Source;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.mule.sdk.api.runtime.source.SourceResult;

@DisplayName(value="MCP Server - On New Session Listener")
public class OnNewSessionListener
extends Source<NewSessionRequest, Void> {
    private static final String FUTURE_CTX_KEY = "_future";
    private static final String ORIGINAL_REQUEST_KEY = "_originalRequest";
    @Config
    private ServerConfig serverConfig;
    @Connection
    private ConnectionProvider<McpAsyncServer> connectionProvider;

    public void onStart(SourceCallback<NewSessionRequest, Void> sourceCallback) throws MuleException {
        this.connectionProvider.connect();
        this.serverConfig.getTransport().onNewSession(request -> {
            CompletableFuture future = new CompletableFuture();
            SourceCallbackContext ctx = sourceCallback.createContext();
            ctx.addVariable(FUTURE_CTX_KEY, future);
            ctx.addVariable(ORIGINAL_REQUEST_KEY, (Object)request);
            sourceCallback.handle(Result.builder().output((Object)new NewSessionRequest(request.getSession().getId(), request.getAdditionalProperties(), request.getClientCertificate())).build(), ctx);
            return future;
        });
    }

    @OnSuccess
    public void onSuccess(@ParameterGroup(name="Rejection", showInDsl=true) RejectNewSessionParameterGroup reject, SourceCallbackContext ctx) {
        InternalNewSessionRequest request = this.getOriginalRequest(ctx);
        if (reject.isReject()) {
            request.reject(reject.getRejectWithMessage(), reject.getRejectWithStatusCode());
        }
    }

    @OnError
    public void onError(Error error, SourceCallbackContext ctx) {
        this.getOriginalRequest(ctx).reject(error.getDescription(), 500);
    }

    @OnTerminate
    public void onTerminate(SourceResult result) {
        SourceCallbackContext ctx = result.getSourceCallbackContext();
        CompletableFuture<InternalNewSessionRequest> future = this.getFuture(ctx);
        if (result.isSuccess()) {
            future.complete(this.getOriginalRequest(ctx));
        } else {
            Error error = result.getInvocationError().orElse(result.getResponseError().orElse(null));
            if (error != null) {
                future.completeExceptionally(error.getCause());
            } else {
                future.completeExceptionally((Throwable)new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Server connection listener failed but couldn't obtain error")));
            }
        }
    }

    private InternalNewSessionRequest getOriginalRequest(SourceCallbackContext ctx) {
        return (InternalNewSessionRequest)ctx.getVariable(ORIGINAL_REQUEST_KEY).get();
    }

    private CompletableFuture<InternalNewSessionRequest> getFuture(SourceCallbackContext ctx) {
        return (CompletableFuture)ctx.getVariable(FUTURE_CTX_KEY).get();
    }

    public void onStop() {
        this.serverConfig.getTransport().onNewSession(null);
    }
}

