/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.connectors.mcp.internal.tracing;

import java.net.URI;
import java.net.URISyntaxException;
import org.mule.sdk.api.runtime.source.DistributedTraceContextManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SpanCustomizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpanCustomizer.class);
    protected static final String HTTP_METHOD = "http.method";
    protected static final String HTTP_FLAVOR = "http.flavor";
    protected static final String SPAN_KIND = "span.kind.override";
    protected final DistributedTraceContextManager traceContextManager;

    public SpanCustomizer(DistributedTraceContextManager traceContextManager) {
        this.traceContextManager = traceContextManager;
    }

    public void customizeSpan() {
        try {
            this.traceContextManager.addCurrentSpanAttribute(HTTP_METHOD, this.getMethod());
            this.traceContextManager.addCurrentSpanAttribute(SPAN_KIND, this.getSpanKind());
            String flavor = this.getFlavor();
            if (flavor != null) {
                this.traceContextManager.addCurrentSpanAttribute(HTTP_FLAVOR, flavor);
            }
        }
        catch (Throwable e) {
            LOGGER.warn("Error on customizing Request Span.", e);
        }
    }

    public abstract String getProtocol();

    public abstract String getMethod();

    public abstract String getFlavor();

    public abstract URI getURI() throws URISyntaxException;

    protected abstract String getSpanKind();
}

